/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.javaLog;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;
import org.objectweb.util.monolog.wrapper.javaLog.GenericHandler;
import org.objectweb.util.monolog.wrapper.javaLog.LevelImpl;
import org.objectweb.util.monolog.wrapper.javaLog.Logger;

public class LoggerFactory
extends AbstractFactory {
    protected static LogManager manager = null;
    protected static Logger rootLogger = null;
    public static final String JAVALOG_CONFIGURATION = "javaLogConfiguration";
    public static final String DEFAULT = "default";
    public static final String PROPERTY = "property";
    public static final String CLASS = "class";
    public static final String JAVALOG_CONFIGURATION_FILE = "javaLogConfigurationFile";
    public static final String JAVALOG_CONFIGURATION_CLASS = "javaLogConfigurationClass";
    static /* synthetic */ Class class$org$objectweb$util$monolog$wrapper$javaLog$Logger;

    protected synchronized Logger getMonoLogger(String name, String resName) {
        if (name == null) {
            throw new IllegalArgumentException("The specified Logger name is null");
        }
        if (name.equals("root") || name.length() == 0) {
            return rootLogger;
        }
        java.util.logging.Logger o = manager.getLogger(name);
        if (o == null) {
            Logger result = new Logger(name, resName);
            Monolog.debug("Instanciate the logger " + name);
            manager.addLogger(result);
            return result;
        }
        if (!o.getClass().equals(class$org$objectweb$util$monolog$wrapper$javaLog$Logger == null ? (class$org$objectweb$util$monolog$wrapper$javaLog$Logger = LoggerFactory.class$("org.objectweb.util.monolog.wrapper.javaLog.Logger")) : class$org$objectweb$util$monolog$wrapper$javaLog$Logger)) {
            throw new RuntimeException("Bad logger class (logger name: '" + name + "'), expected: " + (class$org$objectweb$util$monolog$wrapper$javaLog$Logger == null ? (class$org$objectweb$util$monolog$wrapper$javaLog$Logger = LoggerFactory.class$("org.objectweb.util.monolog.wrapper.javaLog.Logger")) : class$org$objectweb$util$monolog$wrapper$javaLog$Logger) + ", found: " + o.getClass());
        }
        return (Logger)o;
    }

    public void configure(Properties prop) throws Exception {
        if (prop == null) {
            return;
        }
        String confMode = prop.getProperty(JAVALOG_CONFIGURATION, null);
        if (confMode == null) {
            return;
        }
        String param = null;
        if (confMode.equals(PROPERTY)) {
            param = prop.getProperty(JAVALOG_CONFIGURATION_FILE, null);
            if (param != null) {
                System.setProperty("java.util.logging.config.file", param);
            }
            manager.readConfiguration();
        } else if (confMode.equals(CLASS)) {
            param = prop.getProperty(JAVALOG_CONFIGURATION_CLASS, null);
            if (param != null) {
                System.setProperty("java.util.logging.config.class", param);
            }
            manager.readConfiguration();
        }
    }

    public org.objectweb.util.monolog.api.Logger getLogger(String key) {
        return this.getMonoLogger(key, this.resourceBundleName);
    }

    public org.objectweb.util.monolog.api.Logger getLogger(String key, String rbn) {
        return this.getMonoLogger(key, rbn);
    }

    public org.objectweb.util.monolog.api.Logger[] getLoggers() {
        ArrayList<java.util.logging.Logger> res = new ArrayList<java.util.logging.Logger>();
        Enumeration<String> e = manager.getLoggerNames();
        while (e.hasMoreElements()) {
            res.add(manager.getLogger(e.nextElement()));
        }
        return res.toArray(new Logger[0]);
    }

    public Handler createHandler(String hn, byte ht) {
        Handler res = (Handler)this.handlers.get(hn);
        if (res != null) {
            return res;
        }
        switch (ht) {
            case 2: {
                ConsoleHandler ch = new ConsoleHandler();
                ch.setLevel(Level.FINEST);
                res = new GenericHandler(hn, ch, ht);
                break;
            }
            case 1: {
                try {
                    FileHandler fh = new FileHandler();
                    fh.setLevel(Level.FINEST);
                    res = new GenericHandler(hn, fh, ht);
                    break;
                }
                catch (Exception e) {
                    AbstractFactory.debug(e.getMessage());
                    return null;
                }
            }
            case 3: {
                return null;
            }
            case 4: {
                res = new GenericHandler(hn, ht);
                break;
            }
            default: {
                return null;
            }
        }
        this.handlers.put(hn, res);
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BasicLevel.INHERIT = -1;
        LoggerFactory.debug("INHERIT= " + BasicLevel.INHERIT);
        BasicLevel.DEBUG = Level.FINEST.intValue();
        LoggerFactory.debug("DEBUG= " + BasicLevel.DEBUG);
        BasicLevel.INFO = Level.INFO.intValue();
        LoggerFactory.debug("INFO= " + BasicLevel.INFO);
        BasicLevel.WARN = Level.WARNING.intValue();
        LoggerFactory.debug("WARN= " + BasicLevel.WARN);
        BasicLevel.ERROR = Level.SEVERE.intValue();
        LoggerFactory.debug("ERROR= " + BasicLevel.ERROR);
        BasicLevel.FATAL = Level.SEVERE.intValue();
        LoggerFactory.debug("FATAL= " + BasicLevel.FATAL);
        BasicLevel.LEVEL_INHERIT = new LevelImpl("INHERIT", BasicLevel.INHERIT);
        BasicLevel.LEVEL_DEBUG = new LevelImpl("DEBUG", BasicLevel.DEBUG);
        BasicLevel.LEVEL_INFO = new LevelImpl("INFO", BasicLevel.INFO);
        BasicLevel.LEVEL_WARN = new LevelImpl("WARN", BasicLevel.WARN);
        BasicLevel.LEVEL_ERROR = new LevelImpl("ERROR", BasicLevel.ERROR);
        BasicLevel.LEVEL_FATAL = new LevelImpl("FATAL", BasicLevel.FATAL);
        manager = LogManager.getLogManager();
        rootLogger = new Logger(manager.getLogger(""));
    }
}

