/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.printwriter;

import java.io.PrintWriter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Loggable;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.wrapper.printwriter.EmptyWriter;

public class PrintWriterImpl
extends PrintWriter
implements Loggable {
    protected Logger logger = null;
    protected LoggerFactory loggerFactory = null;
    protected int level;
    protected String currentLine = "";
    protected boolean errors = false;

    public PrintWriterImpl(Logger l) throws NullPointerException {
        super(new EmptyWriter());
        if (l == null) {
            throw new NullPointerException("Logger parameter is null");
        }
        this.logger = l;
        this.level = BasicLevel.DEBUG;
    }

    public PrintWriterImpl(Logger logger, LoggerFactory loggerFactory) throws NullPointerException {
        this(logger);
        if (loggerFactory == null) {
            throw new NullPointerException("LoggerFactory parameter is null");
        }
        this.loggerFactory = loggerFactory;
    }

    public PrintWriterImpl(Logger l, int level) throws NullPointerException {
        super(new EmptyWriter());
        if (l == null) {
            throw new NullPointerException("Logger parameter is null");
        }
        this.logger = l;
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLoggerFactory(LoggerFactory lf) {
        this.loggerFactory = lf;
    }

    public boolean checkError() {
        if (this.currentLine.length() > 0) {
            this.logger.log(BasicLevel.INFO, (Object)this.currentLine);
            this.currentLine = "";
        }
        return this.errors;
    }

    public void close() {
        if (this.currentLine.length() > 0) {
            this.logger.log(BasicLevel.INFO, (Object)this.currentLine);
            this.currentLine = "";
        }
    }

    public void flush() {
        if (this.currentLine.length() > 0) {
            this.logger.log(BasicLevel.INFO, (Object)this.currentLine);
            this.currentLine = "";
        }
    }

    public void print(boolean x) {
        this.currentLine = this.currentLine + x;
    }

    public void print(char x) {
        this.currentLine = this.currentLine + x;
    }

    public void print(char[] x) {
        this.currentLine = this.currentLine + new String(x);
    }

    public void print(double x) {
        this.currentLine = this.currentLine + x;
    }

    public void print(float x) {
        this.currentLine = this.currentLine + x;
    }

    public void print(int x) {
        this.currentLine = this.currentLine + x;
    }

    public void print(long x) {
        this.currentLine = this.currentLine + x;
    }

    public void print(Object x) {
        this.currentLine = this.currentLine + x;
    }

    public void print(String x) {
        this.currentLine = this.currentLine + x;
    }

    public void println() {
        this.logger.log(this.level, (Object)this.currentLine);
        this.currentLine = "";
    }

    public void println(boolean x) {
        this.logger.log(this.level, (Object)(this.currentLine + x));
        this.currentLine = "";
    }

    public void println(char x) {
        this.logger.log(this.level, (Object)(this.currentLine + x));
        this.currentLine = "";
    }

    public void println(char[] x) {
        this.logger.log(this.level, (Object)(this.currentLine + new String(x)));
        this.currentLine = "";
    }

    public void println(double x) {
        this.logger.log(this.level, (Object)(this.currentLine + x));
        this.currentLine = "";
    }

    public void println(float x) {
        this.logger.log(this.level, (Object)(this.currentLine + x));
        this.currentLine = "";
    }

    public void println(int x) {
        this.logger.log(this.level, (Object)(this.currentLine + x));
        this.currentLine = "";
    }

    public void println(long x) {
        this.logger.log(this.level, (Object)(this.currentLine + x));
        this.currentLine = "";
    }

    public void println(Object x) {
        this.logger.log(this.level, (Object)(this.currentLine + x));
        this.currentLine = "";
    }

    public void println(String x) {
        this.logger.log(this.level, (Object)(this.currentLine + x));
        this.currentLine = "";
    }

    protected void setError() {
        this.errors = true;
        this.logger.log(BasicLevel.ERROR, (Object)(this.currentLine + "PrintWriter error"));
        this.currentLine = "";
    }

    public void write(char[] buf) {
        this.currentLine = this.currentLine + new String(buf);
    }

    public void write(char[] buf, int off, int len) {
        this.currentLine = this.currentLine + new String(buf, off, len);
    }

    public void write(int c) {
        this.currentLine = this.currentLine + c;
    }

    public void write(String s) {
        this.currentLine = this.currentLine + s;
    }

    public void write(String s, int off, int len) {
        this.currentLine = this.currentLine + (s != null ? s.substring(off, len) : "");
    }
}

