/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.management.MalformedObjectNameException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.probe.Probe;
import org.objectweb.lewys.probe.linux.NetworkProbe;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Grapher;
import org.ow2.jasmine.monitoring.mbeancmd.jasmine.JasmineConnector;

public class Lewys
extends AbstractCommand {
    private Options options = null;
    private CommandLine commandLine = null;
    private Probe probe;
    private Object serverName;
    private Object domainName;
    private int[] resourceIds;
    private int NBRESOURCE = 4;
    private long[] previousValues = null;
    private List arg_probe_config;
    private long period = 10L;
    private String graphDef = null;
    private String outputFilePath = null;
    private String jasmineURI = null;
    private PrintStream pout = null;
    private String separator = ";";
    private String header = null;

    public Lewys() {
        this.setOptions();
    }

    public static void main(String[] args) {
        Lewys p = new Lewys();
        p.setArgs("lewys", args);
        p.exec(null);
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        block18: {
            try {
                if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                    this.probe = new NetworkProbe();
                    break block18;
                }
                if (System.getProperty("os.name").startsWith("Windows")) {
                    this.probe = new org.objectweb.lewys.probe.windows.NetworkProbe();
                    break block18;
                }
                if (System.getProperty("os.name").equals("Mac OS X")) {
                    this.probe = new org.objectweb.lewys.probe.macosx.NetworkProbe();
                    break block18;
                }
                throw new RuntimeException("No Network probe available for " + System.getProperty("os.name"));
            }
            catch (NoResourceToProbeException ex) {
                throw new RuntimeException("Can't set Network probe", ex);
            }
        }
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        PipedOutputStream out = new PipedOutputStream();
        this.pout = new PrintStream(out);
        Outer outer = null;
        try {
            if (this.outputFilePath != null) {
                outer = new Outer(out, new File(this.outputFilePath));
            } else if (this.jasmineURI == null) {
                outer = new Outer(out, System.out);
            }
            if (this.jasmineURI != null) {
                if (outer == null) {
                    outer = JasmineConnector.connect(out, this.jasmineURI);
                } else {
                    Outer oldOuter = outer;
                    outer = JasmineConnector.connect(outer, this.jasmineURI);
                    new Thread(oldOuter).start();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.graphDef != null) {
            try {
                PipedOutputStream sink = new PipedOutputStream();
                outer.setSink(sink);
                Grapher gr = new Grapher(sink, this.graphDef);
                gr.start();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        new Thread(outer).start();
        this.process();
        return 0;
    }

    public String summary() {
        return "Periodically probes with LeWYS.";
    }

    public void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.arg_probe_config = Arrays.asList(this.commandLine.getOptionValues("a"));
        if (this.commandLine.hasOption("p")) {
            this.setPeriod();
        }
        if (this.commandLine.hasOption("graph")) {
            this.graphDef = this.commandLine.getOptionValue("graph");
        }
        if (this.commandLine.hasOption("f")) {
            this.outputFilePath = this.commandLine.getOptionValue("f");
        }
        if (this.commandLine.hasOption("jasmine")) {
            this.jasmineURI = this.commandLine.getOptionValue("jasmine");
        }
        if (this.commandLine.hasOption("s")) {
            this.separator = this.commandLine.getOptionValue("s");
            Outer.setSeparator(this.separator);
        }
        if (this.commandLine.hasOption("n")) {
            this.serverName = this.commandLine.getOptionValue("n");
        }
        if (this.commandLine.hasOption("d")) {
            this.domainName = this.commandLine.getOptionValue("d");
        }
    }

    private void process() {
        this.configProbe();
        this.lewysPoll();
    }

    private void configProbe() {
        String[] resourceNames = this.probe.getResourceNames();
        this.resourceIds = new int[this.NBRESOURCE];
        if (!this.arg_probe_config.isEmpty()) {
            int networkcard_index;
            String networkcardName = (String)this.arg_probe_config.get(0);
            for (networkcard_index = 0; networkcard_index < resourceNames.length && !resourceNames[networkcard_index].endsWith(networkcardName + " bytes received"); ++networkcard_index) {
            }
            if (networkcard_index < resourceNames.length) {
                this.resourceIds[0] = 0 + networkcard_index;
                this.resourceIds[1] = 1 + networkcard_index;
                this.resourceIds[2] = 8 + networkcard_index;
                this.resourceIds[3] = 9 + networkcard_index;
                return;
            }
        }
        String exceptionMessage = "";
        exceptionMessage = exceptionMessage + "\n. Bad probe parameters: A correct Networkcard name must be provided in section BladeArgument [pollingPeriod pollingTime Networkcardname]!!\n.\n";
        exceptionMessage = exceptionMessage + ". Networkcard Names for this host are:\n";
        int totalNbResource = 16;
        if (System.getProperty("os.name").equals("Mac OS X")) {
            totalNbResource = 17;
        }
        for (int j = 0; j < resourceNames.length; j += totalNbResource) {
            String name = resourceNames[j].substring(0, resourceNames[j].length() - "bytes received".length());
            exceptionMessage = exceptionMessage + ". " + name + "\n";
        }
        exceptionMessage = exceptionMessage + ".\n. HINT: If a NetworkCardName is too long, provide only the last discriminating characters.\n";
        exceptionMessage = exceptionMessage + ". For Instance: \n\n.                  \"card1 3Gbits/s\"\n.                    in place of \n. \"My PowerFul NetworkCard FULL Duplex card1 3Gbits/s\" \n.\n. ATTENTION: The provided NetWorkCard Name must not comport character \";\" .\n";
        throw new RuntimeException(exceptionMessage);
    }

    private void lewysPoll() {
        boolean goOn = true;
        while (goOn) {
            try {
                long[] values = this.probe.getValue(this.resourceIds);
                if (this.previousValues == null) {
                    this.previousValues = values;
                } else {
                    long[] result = new long[values.length];
                    result[0] = (values[0] - this.previousValues[0]) / 1000L;
                    result[1] = values[1] - this.previousValues[1];
                    result[2] = (values[2] - this.previousValues[2]) / 1000L;
                    result[3] = values[3] - this.previousValues[3];
                    long t = System.currentTimeMillis();
                    this.printResult(t, result);
                    this.previousValues = values;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            try {
                Thread.sleep(this.period * 1000L);
            }
            catch (InterruptedException e) {
                goOn = false;
            }
        }
    }

    private String getMBeanPollHeader() {
        if (this.header == null) {
            StringBuffer buf = new StringBuffer(512);
            buf.append("date");
            buf.append(this.separator);
            buf.append("time");
            buf.append(this.separator);
            buf.append("sname");
            buf.append(this.separator);
            buf.append("server");
            buf.append(this.separator);
            buf.append("domain");
            buf.append(this.separator);
            buf.append("mbean");
            buf.append(this.separator);
            buf.append("KbytesReceived");
            buf.append(this.separator);
            buf.append("packetsReceived");
            buf.append(this.separator);
            buf.append("KbytesTransmit");
            buf.append(this.separator);
            buf.append("packetsTransmit");
            this.header = buf.toString();
        }
        return this.header;
    }

    private void printResult(long t, long[] result) {
        if (this.header == null) {
            this.pout.println(this.getMBeanPollHeader());
        }
        Date d = new Date(t);
        this.pout.print(SIMPLEDATEFORMAT.format(d));
        this.pout.print(this.separator);
        this.pout.print(t);
        this.pout.print(this.separator);
        this.pout.print("na");
        this.pout.print(this.separator);
        this.pout.print(this.serverName);
        this.pout.print(this.separator);
        this.pout.print(this.domainName);
        this.pout.print(this.separator);
        this.pout.print("network");
        this.pout.print(this.separator);
        this.pout.print(result[0]);
        this.pout.print(this.separator);
        this.pout.print(result[1]);
        this.pout.print(this.separator);
        this.pout.print(result[2]);
        this.pout.print(this.separator);
        this.pout.print(result[3]);
        this.pout.println();
    }

    private void setPeriod() throws NumberFormatException {
        this.period = Long.parseLong(this.commandLine.getOptionValue("p"));
    }

    private void setOptions() {
        this.options = new Options();
        this.options.addOption("v", "verbose", false, "Verbose mode");
        Option atts = new Option("a", "atts", true, "attributes to poll");
        atts.setRequired(false);
        atts.setOptionalArg(true);
        atts.setArgs(-2);
        atts.setArgName("attributes");
        this.options.addOption(atts);
        Option period = new Option("p", "period", true, "Polling period");
        atts.setRequired(false);
        period.setArgName("period");
        period.setArgs(1);
        this.options.addOption(period);
        Option graph = new Option("graph", "graph", true, "Enable graphical output");
        graph.setRequired(false);
        graph.setArgName("graphDefinition");
        graph.setArgs(1);
        this.options.addOption(graph);
        Option file = new Option("f", "file", true, "Send output to file instead of stdout");
        file.setRequired(false);
        file.setArgName("path");
        file.setArgs(1);
        this.options.addOption(file);
        Option jasmine = new Option("jasmine", "jasmine", true, "Output logged data to jasmine (will disable stdout)");
        jasmine.setRequired(false);
        jasmine.setArgName("jasmineURI");
        jasmine.setArgs(1);
        this.options.addOption(jasmine);
        Option separator = new Option("s", "separator", true, "Set the column separator");
        separator.setRequired(false);
        separator.setArgName("separator");
        separator.setArgs(1);
        this.options.addOption(separator);
        Option server = new Option("n", "name", true, "Server name");
        server.setRequired(false);
        server.setArgName("serverName");
        server.setArgs(1);
        this.options.addOption(server);
        Option domain = new Option("d", "domain", true, "Domain name");
        domain.setRequired(false);
        domain.setArgName("domainName");
        domain.setArgs(1);
        this.options.addOption(domain);
    }
}

