/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.JoramQData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;

public class JoramQSampler
extends Sampler {
    private static final String[] attIds = new String[]{"NbMsgsDeliverSinceCreation", "NbMsgsReceiveSinceCreation", "NbMsgsSentToDMQSinceCreation", "PendingMessageCount", "WaitingRequestCount", "CreationTimeInMillis", "NbMaxMsg"};
    private ObjectName[] onQueues = null;
    private boolean refreshable = true;
    private boolean hasFailed = false;
    private long refreshDeadLine = 0L;
    private long refreshTimeout = 300000L;

    public JoramQSampler(SamplerContext context) {
        super(context);
    }

    public String getDefaultOnPattern() {
        return "joramClient:type=Queue,*";
    }

    protected SampleData newSampleData() {
        return new XSampleData();
    }

    private void refreshQueueON() throws Exception {
        if (this.isRefreshable()) {
            ObjectName[] ons = null;
            LinkedList<ObjectName> lon = new LinkedList<ObjectName>();
            ObjectName[] onDest = this.queryON("*:type=Destination,*");
            ObjectName[] joramClients = this.queryON(this.getOnPattern());
            if (onDest != null && joramClients != null) {
                for (ObjectName destON : onDest) {
                    for (ObjectName queueON : joramClients) {
                        String destName = destON.getKeyProperty("name");
                        String queueName = queueON.getKeyProperty("name");
                        if (!queueName.startsWith(destName)) continue;
                        lon.add(destON);
                    }
                }
            }
            if (!lon.isEmpty()) {
                ons = lon.toArray(new ObjectName[lon.size()]);
            }
            this.onQueues = ons;
            if (this.onQueues != null || !this.hasFailed) {
                this.setRefreshable(false);
                this.refreshDeadLine = 0L;
                this.hasFailed = false;
            } else if (this.refreshDeadLine == 0L) {
                this.refreshDeadLine = System.currentTimeMillis() + this.refreshTimeout;
            } else if (System.currentTimeMillis() >= this.refreshDeadLine) {
                this.setRefreshable(false);
                this.refreshDeadLine = 0L;
                this.hasFailed = false;
            }
        }
    }

    protected SampleData poll(SampleData data) {
        this.pollJoramQueues((XSampleData)data);
        data.setValid(true);
        return data;
    }

    private void pollJoramQueues(XSampleData data) {
        try {
            this.refreshQueueON();
        }
        catch (Exception e) {
            return;
        }
        if (this.onQueues != null) {
            for (ObjectName queue : this.onQueues) {
                JoramQData qdata = new JoramQData();
                qdata.setObjectName(queue);
                qdata.setSampleTime(System.currentTimeMillis());
                this.pollJoramQueue(queue, qdata);
                if (!qdata.isValid()) continue;
                data.put(queue, qdata);
            }
        }
    }

    private void pollJoramQueue(ObjectName on, JoramQData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        try {
            cnx = this.getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            this.releaseMbeanServerConnection();
            cnx = null;
            Iterator it = al.iterator();
            if (it.hasNext()) {
                data.setAttribute(new Attribute("AdminName", on.getKeyProperty("name")));
            }
            while (it.hasNext()) {
                Attribute att = (Attribute)it.next();
                data.setAttribute(att);
            }
            data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
            data.setValid(true);
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Error on mbean " + on + " for " + this.context.getName() + " : " + e.getMessage());
            this.setRefreshable(true);
            this.hasFailed = true;
        }
        catch (ReflectionException e) {
            System.err.println("Error on mbean " + on + " for " + this.context.getName() + " : " + e.getMessage());
            this.setRefreshable(true);
            this.hasFailed = true;
        }
        catch (IOException e) {
            System.err.println("Error on mbean " + on + " for " + this.context.getName() + " : " + e.getMessage());
            this.setRefreshable(true);
            this.hasFailed = true;
        }
    }

    private void pollJoramQueue_DEPRECATED(ObjectName on, JoramQData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        boolean hasStatistics = false;
        try {
            cnx = this.getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            this.releaseMbeanServerConnection();
            cnx = null;
            for (Attribute att : al) {
                if ("Statistic".equals(att.getName())) {
                    Hashtable ht = (Hashtable)att.getValue();
                    Attribute a1 = new Attribute("creationDate", ht.get("creationDate"));
                    data.setAttribute(a1);
                    a1 = new Attribute("nbMsgsReceiveSinceCreation", ht.get("nbMsgsReceiveSinceCreation"));
                    data.setAttribute(a1);
                    a1 = new Attribute("nbMsgsSendToDMQSinceCreation", ht.get("nbMsgsSendToDMQSinceCreation"));
                    data.setAttribute(a1);
                    a1 = new Attribute("nbMsgsDeliverSinceCreation", ht.get("nbMsgsDeliverSinceCreation"));
                    data.setAttribute(a1);
                    hasStatistics = true;
                    continue;
                }
                data.setAttribute(att);
            }
            data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
            if (hasStatistics) {
                data.setValid(true);
            } else {
                data.setValid(false);
                System.err.println("Error on mbean " + on + " for " + this.context.getName() + " : no Statistic attribute ");
            }
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Error on mbean " + on + " for " + this.context.getName() + " : " + e.getMessage());
            this.setRefreshable(true);
            this.hasFailed = true;
        }
        catch (ReflectionException e) {
            System.err.println("Error on mbean " + on + " for " + this.context.getName() + " : " + e.getMessage());
            this.setRefreshable(true);
            this.hasFailed = true;
        }
        catch (IOException e) {
            System.err.println("Error on mbean " + on + " for " + this.context.getName() + " : " + e.getMessage());
            this.setRefreshable(true);
            this.hasFailed = true;
        }
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    public void setRefreshable(boolean refreshable) {
        this.refreshable = refreshable;
    }
}

