/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.ServletData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;

public class ServletSampler
extends Sampler {
    public ServletSampler(SamplerContext context) {
        super(context);
    }

    public String getDefaultOnPattern() {
        return "*:j2eeType=Servlet,J2EEApplication=pulsar,*";
    }

    protected SampleData newSampleData() {
        return new XSampleData();
    }

    protected SampleData poll(SampleData data) {
        this.pollServlets((XSampleData)data);
        data.setValid(true);
        return data;
    }

    private void pollServlets(XSampleData data) {
        if (this.context.getOnames() == null) {
            return;
        }
        ObjectName[] oNames = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
        for (int i = 0; i < oNames.length; ++i) {
            ServletData sdata = new ServletData();
            sdata.setObjectName(oNames[i]);
            sdata.setSampleTime(System.currentTimeMillis());
            this.pollServlet(oNames[i], sdata);
            if (!sdata.isValid()) continue;
            data.put(oNames[i], sdata);
        }
    }

    private void pollServlet(ObjectName on, ServletData data) {
        int reqCnt = 0;
        int errCnt = 0;
        long procTime = 0L;
        long maxTime = 0L;
        long minTime = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"requestCount", "errorCount", "processingTime", "maxTime", "minTime"};
        try {
            cnx = this.getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            this.releaseMbeanServerConnection();
            cnx = null;
            Iterator it = al.iterator();
            Attribute att = (Attribute)it.next();
            reqCnt = (Integer)att.getValue();
            att = (Attribute)it.next();
            errCnt = (Integer)att.getValue();
            att = (Attribute)it.next();
            procTime = (Long)att.getValue();
            att = (Attribute)it.next();
            maxTime = (Long)att.getValue();
            att = (Attribute)it.next();
            minTime = (Long)att.getValue();
            data.setRequestCount(reqCnt);
            data.setErrorCount(errCnt);
            data.setProcessingTime(procTime);
            data.setMaxTime(maxTime);
            data.setMinTime(minTime);
            data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
            data.setValid(true);
        }
        catch (Exception e) {
            this.logger.error("MBean error: {0}", e.getMessage());
        }
    }
}

