/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseRouter;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.ResponseTimeoutException;
import org.mule.umo.routing.RoutingException;
import org.mule.util.MapUtils;
import org.mule.util.concurrent.Latch;

public abstract class AbstractResponseAggregator
extends AbstractResponseRouter {
    protected final ConcurrentMap eventGroups = new ConcurrentHashMap();
    protected final ConcurrentMap locks = new ConcurrentHashMap();
    protected final ConcurrentMap responseMessages = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(UMOEvent event) throws RoutingException {
        EventGroup group;
        Object groupId = this.getReplyAggregateIdentifier(event.getMessage());
        if (groupId == null) throw new RoutingException(CoreMessages.noCorrelationId(), event.getMessage(), event.getEndpoint());
        if (groupId.equals("-1")) {
            throw new RoutingException(CoreMessages.noCorrelationId(), event.getMessage(), event.getEndpoint());
        }
        boolean lookupMiss = false;
        while (true) {
            if (lookupMiss) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if ((group = this.getEventGroup(groupId)) == null) {
                group = this.addEventGroup(this.createEventGroup(event, groupId));
            }
            EventGroup eventGroup = group;
            synchronized (eventGroup) {
                if (group == this.getEventGroup(groupId)) break;
                lookupMiss = true;
            }
        }
        {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding event to response aggregator group: " + groupId);
            }
            group.addEvent(event);
            if (!this.shouldAggregateEvents(group)) return;
            UMOMessage returnMessage = this.aggregateEvents(group);
            this.removeEventGroup(group);
            UMOMessage previousResult = (UMOMessage)this.responseMessages.putIfAbsent(groupId, returnMessage);
            if (previousResult != null) {
                throw new IllegalStateException("Detected duplicate aggregation result message with id: " + groupId);
            }
            Latch l = (Latch)this.locks.get(groupId);
            if (l == null) {
                Latch previous;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Creating latch for " + groupId + " in " + this);
                }
                if ((previous = (Latch)this.locks.putIfAbsent(groupId, l = new Latch())) != null) {
                    l = previous;
                }
            }
            l.countDown();
            return;
        }
    }

    protected EventGroup createEventGroup(UMOEvent event, Object groupId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating new event group: " + groupId + " in " + this);
        }
        return new EventGroup(groupId);
    }

    protected EventGroup getEventGroup(Object groupId) {
        return (EventGroup)this.eventGroups.get(groupId);
    }

    protected EventGroup addEventGroup(EventGroup group) {
        EventGroup previous = (EventGroup)this.eventGroups.putIfAbsent(group.getGroupId(), group);
        return previous != null ? previous : group;
    }

    protected void removeEventGroup(EventGroup group) {
        this.eventGroups.remove(group.getGroupId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UMOMessage getResponse(UMOMessage message) throws RoutingException {
        void var4_4;
        boolean resultAvailable;
        Object responseId;
        block20: {
            UMOMessage result;
            Latch l;
            responseId = this.getCallResponseAggregateIdentifier(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Waiting for response for message id: " + responseId + " in " + this);
            }
            if ((l = (Latch)this.locks.get(responseId)) == null) {
                Latch previous;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Got response but no one is waiting for it yet. Creating latch for " + responseId + " in " + this);
                }
                if ((previous = (Latch)this.locks.putIfAbsent(responseId, l = new Latch())) != null) {
                    l = previous;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Got latch for message: " + responseId);
            }
            resultAvailable = false;
            boolean interruptedWhileWaiting = false;
            try {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Waiting for response to message: " + responseId);
                    }
                    if (this.getTimeout() <= 0) {
                        l.await();
                        resultAvailable = true;
                    } else {
                        resultAvailable = l.await(this.getTimeout(), TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException e) {
                    interruptedWhileWaiting = true;
                    Object var9_8 = null;
                    this.locks.remove(responseId);
                    result = (UMOMessage)this.responseMessages.remove(responseId);
                    if (interruptedWhileWaiting) {
                        Thread.currentThread().interrupt();
                    }
                    break block20;
                }
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.locks.remove(responseId);
                result = (UMOMessage)this.responseMessages.remove(responseId);
                if (interruptedWhileWaiting) {
                    Thread.currentThread().interrupt();
                }
                throw throwable;
            }
            this.locks.remove(responseId);
            result = (UMOMessage)this.responseMessages.remove(responseId);
            if (interruptedWhileWaiting) {
                Thread.currentThread().interrupt();
            }
        }
        if (!resultAvailable) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Current responses are: \n" + MapUtils.toString(this.responseMessages, true));
            }
            throw new ResponseTimeoutException(CoreMessages.responseTimedOutWaitingForId(this.getTimeout(), responseId), message, null);
        }
        if (var4_4 == null) {
            throw new IllegalStateException("Response Message is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remaining locks  : " + this.locks.keySet());
            this.logger.debug("remaining results: " + this.responseMessages.keySet());
        }
        return var4_4;
    }

    protected abstract boolean shouldAggregateEvents(EventGroup var1);

    protected abstract UMOMessage aggregateEvents(EventGroup var1) throws RoutingException;
}

