/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream;

import java.util.Hashtable;
import java.util.Map;
import org.objectweb.dream.InitializationException;
import org.objectweb.dream.control.logger.Loggable;
import org.objectweb.dream.control.logger.LoggerControllerRegister;
import org.objectweb.dream.util.NullLogger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.julia.control.binding.ChainedIllegalBindingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class AbstractComponent
implements LifeCycleController,
BindingController,
Loggable {
    public Component weaveableC;
    protected Logger logger = NullLogger.NULL_LOGGER;
    protected Logger lifeCycleLogger = NullLogger.NULL_LOGGER;
    protected Logger bindingLogger = NullLogger.NULL_LOGGER;
    private Map bindings = new Hashtable();
    protected String fcState = "STOPPED";
    protected Component componentDesc;

    protected void initComponent(Component componentItf) throws InitializationException {
        try {
            LoggerControllerRegister lcr = (LoggerControllerRegister)this.weaveableC.getFcInterface("/logger-controller-register");
            lcr.register(null, this);
            lcr.register("life-cycle", this);
            lcr.register("binding", this);
            this.logger.log(BasicLevel.DEBUG, (Object)"Component initialized.");
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
    }

    public void setLogger(String name, Logger l) {
        if (name == null) {
            this.logger = l;
        } else if (name.equals("life-cycle")) {
            this.lifeCycleLogger = l;
        } else if (name.equals("binding")) {
            this.bindingLogger = l;
        }
    }

    public String getFcState() {
        if (this.lifeCycleLogger.isLoggable(BasicLevel.DEBUG)) {
            this.lifeCycleLogger.log(BasicLevel.DEBUG, (Object)("getFcState: " + this.fcState));
        }
        return this.fcState;
    }

    public void stopFc() throws IllegalLifeCycleException {
        this.fcState = "STOPPED";
        this.lifeCycleLogger.log(BasicLevel.DEBUG, (Object)"stopped");
    }

    public void startFc() throws IllegalLifeCycleException {
        this.fcState = "STARTED";
        this.lifeCycleLogger.log(BasicLevel.DEBUG, (Object)"started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupFc(String clientItfName) throws NoSuchInterfaceException {
        Map map = this.bindings;
        synchronized (map) {
            if (this.bindingLogger.isLoggable(BasicLevel.DEBUG)) {
                this.bindingLogger.log(BasicLevel.DEBUG, (Object)("lookupFc on interface \"" + clientItfName + "\""));
            }
            return this.bindings.get(clientItfName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        Map map = this.bindings;
        synchronized (map) {
            if (this.bindingLogger.isLoggable(BasicLevel.DEBUG)) {
                this.bindingLogger.log(BasicLevel.DEBUG, (Object)("bindFc on interface \"" + clientItfName + "\""));
            }
            if (clientItfName.equals("component")) {
                this.weaveableC = (Component)serverItf;
                try {
                    this.initComponent(this.weaveableC);
                }
                catch (InitializationException e) {
                    this.logger.log(BasicLevel.ERROR, (Object)"An error occurs while initializing the component", (Throwable)e);
                    throw new ChainedIllegalBindingException(e, this.weaveableC, null, "component", null, "An error occurs while initializing component");
                }
            } else {
                this.bindings.put(clientItfName, serverItf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindFc(String clientItfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        Map map = this.bindings;
        synchronized (map) {
            if (this.bindingLogger.isLoggable(BasicLevel.DEBUG)) {
                this.bindingLogger.log(BasicLevel.DEBUG, (Object)("unbindIf on interface \"" + clientItfName + "\""));
            }
            this.bindings.remove(clientItfName);
        }
    }
}

