/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.channel.ChunkBasedSocketManagerAttributeController;
import org.objectweb.dream.channel.IPChannelDestinationChunk;
import org.objectweb.dream.channel.IPSocketManager;
import org.objectweb.dream.channel.SocketManager;
import org.objectweb.dream.channel.SocketState;
import org.objectweb.dream.message.ExtensibleMessage;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;

public class IPChunkBasedSocketManagerImpl
extends AbstractComponent
implements SocketManager,
ChunkBasedSocketManagerAttributeController {
    protected boolean deleteChunk = true;
    protected String destinationChunkName;
    protected MessageManager messageManagerItf;
    protected IPSocketManager delegateSocketManagerItf;

    public SocketState getSocket(Message message) throws IOException {
        IPChannelDestinationChunk chunk = (IPChannelDestinationChunk)message.getChunk(this.destinationChunkName);
        if (chunk == null) {
            throw new IOException("Unable to find \"" + this.destinationChunkName + "\" chunk in message");
        }
        SocketState socketState = this.delegateSocketManagerItf.getSocket(chunk.getChannelDestinationAddr(), chunk.getChannelDestinationPort());
        if (this.deleteChunk && message instanceof ExtensibleMessage) {
            ((ExtensibleMessage)message).removeChunk(this.destinationChunkName);
            this.messageManagerItf.deleteChunk(chunk);
        }
        return socketState;
    }

    public void releaseSocket(SocketState socketState) {
        this.delegateSocketManagerItf.releaseSocket(socketState);
    }

    public boolean getDeleteChunk() {
        return this.deleteChunk;
    }

    public void setDeleteChunk(boolean deleteChunk) {
        this.deleteChunk = deleteChunk;
    }

    public String getDestinationChunkName() {
        return this.destinationChunkName;
    }

    public void setDestinationChunkName(String destinationChunkName) {
        this.destinationChunkName = destinationChunkName;
    }

    public String[] listFc() {
        return new String[]{"message-manager", "ip-socket-manager"};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        } else if (clientItfName.equals("ip-socket-manager")) {
            this.delegateSocketManagerItf = (IPSocketManager)serverItf;
        }
    }
}

