/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import org.objectweb.dream.PushException;
import org.objectweb.dream.channel.AbstractTCPChannelOutImpl;
import org.objectweb.dream.channel.MonoDestinationIPChannelOutAttributeController;
import org.objectweb.dream.message.Message;
import org.objectweb.util.monolog.api.BasicLevel;

public class MonoDestinationTCPChannelOutImpl
extends AbstractTCPChannelOutImpl
implements MonoDestinationIPChannelOutAttributeController {
    protected InetAddress inetAddress;
    protected int port;
    protected Socket sock;
    protected ObjectOutputStream oos;

    public synchronized void push(Message message, Map context) throws PushException {
        try {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("try to send message -> " + message));
            }
            if (this.sock == null || !this.sock.isConnected()) {
                if (this.oos != null) {
                    try {
                        this.oos.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (this.sock != null) {
                    try {
                        this.sock.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.sock = this.connectSocket(this.inetAddress, this.getPort());
                this.oos = new ObjectOutputStream(this.sock.getOutputStream());
            }
            this.logger.log(BasicLevel.DEBUG, (Object)"write message");
            this.messageCodecItf.encode(this.oos, message);
            this.receiveAck(this.sock);
            this.messageManagerItf.deleteMessage(message);
        }
        catch (IOException e) {
            throw new PushException(e);
        }
    }

    public String getInetAddress() {
        return this.inetAddress.getCanonicalHostName();
    }

    public void setInetAddress(String inetAddress) throws UnknownHostException, IOException {
        this.inetAddress = InetAddress.getByName(inetAddress);
        if (this.oos != null) {
            this.oos.close();
        }
        if (this.sock != null) {
            this.sock.close();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected void receiveAck(Socket sock) throws IOException {
    }
}

