/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.channel.BasicSocketStateImpl;
import org.objectweb.dream.channel.IPSocketManager;
import org.objectweb.dream.channel.SocketState;
import org.objectweb.dream.channel.TCPSocketManagerAttributeController;
import org.objectweb.dream.util.EmptyStringArray;
import org.objectweb.util.monolog.api.BasicLevel;

public class TCPBasicIPSocketManagerImpl
extends AbstractComponent
implements IPSocketManager,
TCPSocketManagerAttributeController {
    protected int cnxRetry = 5;
    protected boolean tcpNoDelay = true;
    protected int soTimeout = 0;
    protected int soLinger = 60;

    public SocketState getSocket(InetAddress address, int port) throws IOException {
        int i = 0;
        while (true) {
            try {
                this.logger.log(BasicLevel.DEBUG, (Object)"try to connect");
                Socket sock = new Socket(address, port);
                this.setSocketOption(sock);
                this.logger.log(BasicLevel.DEBUG, (Object)"connected");
                return new BasicSocketStateImpl(sock);
            }
            catch (IOException exc) {
                this.logger.log(BasicLevel.WARN, (Object)("connection failed on address " + address));
                if (i > this.cnxRetry) {
                    throw exc;
                }
                try {
                    Thread.sleep(i * 250);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public void releaseSocket(SocketState socketState) {
        socketState.close();
    }

    protected void setSocketOption(Socket sock) throws SocketException {
        sock.setTcpNoDelay(this.tcpNoDelay);
        sock.setSoTimeout(this.soTimeout);
        if (this.soLinger >= 0) {
            sock.setSoLinger(true, this.soLinger);
        } else {
            sock.setSoLinger(false, 0);
        }
    }

    public int getCnxRetry() {
        return this.cnxRetry;
    }

    public void setCnxRetry(int cnxRetry) {
        this.cnxRetry = cnxRetry;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int timeout) {
        this.soLinger = timeout;
    }

    public String[] listFc() {
        return EmptyStringArray.EMPTY_STRING_ARRAY;
    }
}

