/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.control.activity.task;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.dream.control.activity.scheduler.BasicForwarderSchedulerImpl;
import org.objectweb.dream.control.activity.task.IllegalTaskException;
import org.objectweb.dream.control.activity.task.Task;
import org.objectweb.dream.control.activity.task.TaskLifeCycleController;
import org.objectweb.dream.control.activity.task.TaskManagerController;
import org.objectweb.dream.control.activity.task.TaskStoppedListener;
import org.objectweb.dream.control.activity.task.Util;
import org.objectweb.dream.control.activity.task.thread.BasicThreadTask;
import org.objectweb.dream.control.activity.task.thread.ThreadPoolAttributeController;
import org.objectweb.dream.util.Error;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class ThreadPerTaskTaskManagerControllerMixin
implements TaskManagerController,
TaskStoppedListener {
    protected Map tasks;
    protected Map interruptedTasks;
    public Logger _this_weaveableTMCLogger;
    public ContentController _this_weaveableCC;

    private ThreadPerTaskTaskManagerControllerMixin() {
    }

    public void initFcController(InitializationContext ic) throws InstantiationException {
        this.tasks = new HashMap();
        this.interruptedTasks = new HashMap();
        this._super_initFcController(ic);
    }

    public synchronized Object registerTask(Task task, Map hints) throws IllegalTaskException {
        Component forwarderScheduler;
        Component thread;
        Component componentTask;
        if (this.tasks.containsKey(task)) {
            throw new IllegalTaskException(task, "The task is already registred", null);
        }
        String controllerDesc = (String)hints.get("taskControllerDesc");
        try {
            componentTask = Util.createTask(task, controllerDesc == null ? "taskPrimitive" : controllerDesc);
        }
        catch (InstantiationException e) {
            throw new IllegalTaskException(null, "Unable to instantiate task component", e);
        }
        try {
            this._this_weaveableCC.addFcSubComponent(componentTask);
        }
        catch (IllegalContentException e) {
            throw new IllegalTaskException(task, "Unable to add task component in activity manager", e);
        }
        catch (IllegalLifeCycleException e) {
            throw new IllegalTaskException(task, "Unable to add task component in activity manager", e);
        }
        String taskName = null;
        try {
            taskName = Fractal.getNameController(componentTask).getFcName();
        }
        catch (NoSuchInterfaceException e1) {
            // empty catch block
        }
        Object returnObject = null;
        String s = (String)hints.get("thread");
        if (s != null && "pool".equals(s)) {
            this._this_weaveableTMCLogger.log(BasicLevel.DEBUG, (Object)"Create thread pool task");
            try {
                thread = Util.createThreadPoolTask(taskName == null ? "threadPoolTask" : taskName + "-threadPoolTask");
            }
            catch (InstantiationException e) {
                throw new IllegalTaskException(task, "Unable to create thread pool task component in activity manager", e);
            }
            try {
                returnObject = thread.getFcInterface("thread-pool-controller");
            }
            catch (NoSuchInterfaceException e) {
                Error.bug(this._this_weaveableTMCLogger, e);
            }
            Integer capacity = (Integer)hints.get("threadPool.capacity");
            if (capacity != null) {
                try {
                    ((ThreadPoolAttributeController)Fractal.getAttributeController(thread)).setCapacity(capacity);
                }
                catch (NoSuchInterfaceException e) {
                    Error.bug(this._this_weaveableTMCLogger, e);
                }
            }
        } else {
            this._this_weaveableTMCLogger.log(BasicLevel.DEBUG, (Object)"Create basic thread task");
            try {
                thread = Util.createTask(new BasicThreadTask(), "threadPrimitive");
            }
            catch (InstantiationException e) {
                throw new IllegalTaskException(task, "Unable to create thread task component in activity manager", e);
            }
            returnObject = null;
        }
        if (taskName != null) {
            try {
                Fractal.getNameController(thread).setFcName(taskName + "-thread");
            }
            catch (NoSuchInterfaceException e2) {
                // empty catch block
            }
        }
        try {
            this._this_weaveableCC.addFcSubComponent(thread);
        }
        catch (IllegalContentException e) {
            throw new IllegalTaskException(task, "Unable to add thread task component in activity manager", e);
        }
        catch (IllegalLifeCycleException e) {
            throw new IllegalTaskException(task, "Unable to add thread task component in activity manager", e);
        }
        try {
            forwarderScheduler = Util.createScheduler(new BasicForwarderSchedulerImpl(), taskName == null ? "scheduler" : taskName + "-scheduler");
        }
        catch (InstantiationException e) {
            throw new IllegalTaskException(task, "Unable to create scheduler component in activity manager", e);
        }
        if (taskName != null) {
            try {
                Fractal.getNameController(forwarderScheduler).setFcName(taskName + "-scheduler");
            }
            catch (NoSuchInterfaceException e2) {
                // empty catch block
            }
        }
        try {
            this._this_weaveableCC.addFcSubComponent(forwarderScheduler);
        }
        catch (IllegalContentException e) {
            throw new IllegalTaskException(task, "Unable to add scheduler component in activity manager", e);
        }
        catch (IllegalLifeCycleException e) {
            throw new IllegalTaskException(task, "Unable to add scheduler component in activity manager", e);
        }
        try {
            Fractal.getBindingController(thread).bindFc("scheduler", forwarderScheduler.getFcInterface("scheduler"));
            Fractal.getBindingController(forwarderScheduler).bindFc("task", componentTask.getFcInterface("task"));
        }
        catch (NoSuchInterfaceException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
        catch (IllegalBindingException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
        catch (IllegalLifeCycleException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
        try {
            Fractal.getLifeCycleController(thread).startFc();
        }
        catch (IllegalLifeCycleException e) {
            throw new IllegalTaskException(task, "unable to start thread task component", e);
        }
        catch (NoSuchInterfaceException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
        this.tasks.put(task, new Component[]{componentTask, forwarderScheduler, thread});
        return returnObject;
    }

    public synchronized void unregisterTask(Task task) throws IllegalTaskException {
        if (!this.tasks.containsKey(task)) {
            throw new IllegalTaskException(task, "The task is not registered", null);
        }
        Component[] components = (Component[])this.tasks.get(task);
        Component componentTask = components[0];
        Component forwarderScheduler = components[1];
        Component thread = components[2];
        this.removeTask(task, componentTask, forwarderScheduler, thread);
        this.tasks.remove(task);
    }

    public synchronized void interruptTask(Task task, TaskStoppedListener listener) throws IllegalTaskException {
        if (!this.tasks.containsKey(task)) {
            throw new IllegalTaskException(task, "The task is not registered", null);
        }
        Component[] components = (Component[])this.tasks.get(task);
        Component thread = components[2];
        Object[] taskStatus = new Object[]{task, listener, components[0], components[1]};
        this.interruptedTasks.put(thread, taskStatus);
        try {
            ((TaskLifeCycleController)Fractal.getLifeCycleController(thread)).asyncStop(this);
        }
        catch (NoSuchInterfaceException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
    }

    public Task[] getTasks() {
        if (this.tasks == null) {
            return new Task[0];
        }
        return this.tasks.keySet().toArray(new Task[this.tasks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStopped(Task thread) {
        TaskStoppedListener listener;
        Task task;
        ThreadPerTaskTaskManagerControllerMixin threadPerTaskTaskManagerControllerMixin = this;
        synchronized (threadPerTaskTaskManagerControllerMixin) {
            Component threadComponent = ((Interface)((Object)thread)).getFcItfOwner();
            Object[] taskStatus = (Object[])this.interruptedTasks.get(threadComponent);
            task = (Task)taskStatus[0];
            listener = (TaskStoppedListener)taskStatus[1];
            Component componentTask = (Component)taskStatus[2];
            Component forwarderScheduler = (Component)taskStatus[3];
            try {
                this.removeTask(task, componentTask, forwarderScheduler, threadComponent);
            }
            catch (IllegalTaskException e) {
                Error.bug(this._this_weaveableTMCLogger, e);
            }
            this.interruptedTasks.remove(threadComponent);
        }
        listener.taskStopped(task);
    }

    public void removeTask(Task task, Component componentTask, Component forwarderScheduler, Component thread) throws IllegalTaskException {
        try {
            Fractal.getLifeCycleController(thread).stopFc();
        }
        catch (IllegalLifeCycleException e) {
            throw new IllegalTaskException(task, "unable to stop thread task component", e);
        }
        catch (NoSuchInterfaceException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
        try {
            Fractal.getBindingController(thread).unbindFc("scheduler");
            this._this_weaveableCC.removeFcSubComponent(thread);
            Fractal.getBindingController(forwarderScheduler).unbindFc("task");
            this._this_weaveableCC.removeFcSubComponent(forwarderScheduler);
            this._this_weaveableCC.removeFcSubComponent(componentTask);
        }
        catch (NoSuchInterfaceException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
        catch (IllegalBindingException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
        catch (IllegalLifeCycleException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
        catch (IllegalContentException e) {
            Error.bug(this._this_weaveableTMCLogger, e);
        }
    }

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

