/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.control.lifecycle;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.control.lifecycle.ChainedIllegalLifeCycleException;
import org.objectweb.fractal.julia.control.lifecycle.LifeCycleCoordinator;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class SimpleLifeCycleControllerMixin
implements LifeCycleCoordinator {
    public int weaveableFcState;
    public Component _this_weaveableC;
    public Logger _this_weaveableLCCLogger;

    public void initFcController(InitializationContext ic) throws InstantiationException {
        try {
            if (!(ic.getInterface("lifecycle-controller") instanceof LifeCycleCoordinator)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            try {
                ic.getInterface("/lifecycle-coordinator");
            }
            catch (Exception f) {
                throw new ChainedInstantiationException(f, null, "The component must provide a LifeCycleCoordinator interface");
            }
        }
        this._super_initFcController(ic);
    }

    public String getFcState() {
        return this.weaveableFcState == 0 ? "STOPPED" : "STARTED";
    }

    public void startFc() throws IllegalLifeCycleException {
        if (this.weaveableFcState != 2) {
            this._this_weaveableLCCLogger.log(BasicLevel.DEBUG, (Object)"Start component");
            this._this_setFcState(true);
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (this.weaveableFcState == 2) {
            throw new ChainedIllegalLifeCycleException(null, this._this_weaveableC, "This component can't be stopped alone");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFcStarted() throws IllegalLifeCycleException {
        SimpleLifeCycleControllerMixin simpleLifeCycleControllerMixin = this;
        synchronized (simpleLifeCycleControllerMixin) {
            if (this.weaveableFcState == 2) {
                return false;
            }
            this._this_weaveableLCCLogger.log(BasicLevel.DEBUG, (Object)"Component started");
            this.weaveableFcState = 2;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFcStopping(LifeCycleCoordinator coordinator) throws IllegalLifeCycleException {
        SimpleLifeCycleControllerMixin simpleLifeCycleControllerMixin = this;
        synchronized (simpleLifeCycleControllerMixin) {
            this._this_weaveableLCCLogger.log(BasicLevel.DEBUG, (Object)"Stopping component");
            this.weaveableFcState = 1;
            this.isInactivated(coordinator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFcStopped() throws IllegalLifeCycleException {
        SimpleLifeCycleControllerMixin simpleLifeCycleControllerMixin = this;
        synchronized (simpleLifeCycleControllerMixin) {
            if (this.weaveableFcState == 0) {
                return false;
            }
            this._this_weaveableLCCLogger.log(BasicLevel.DEBUG, (Object)"Component stopped");
            this.weaveableFcState = 0;
            return true;
        }
    }

    public boolean checkInactivity() {
        return true;
    }

    public boolean isInactivated(LifeCycleCoordinator coordinator) {
        if (this.checkInactivity()) {
            this._this_weaveableLCCLogger.log(BasicLevel.DEBUG, (Object)"Component inactivated");
            coordinator.fcInactivated(this.getFcCoordinator());
            return true;
        }
        return false;
    }

    public LifeCycleCoordinator getFcCoordinator() {
        try {
            return (LifeCycleCoordinator)this._this_weaveableC.getFcInterface("lifecycle-controller");
        }
        catch (Exception e) {
            try {
                return (LifeCycleCoordinator)this._this_weaveableC.getFcInterface("/lifecycle-coordinator");
            }
            catch (NoSuchInterfaceException f) {
                throw new Error("Internal error");
            }
        }
    }

    public abstract void _this_setFcState(boolean var1) throws IllegalLifeCycleException;

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

