/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.message.codec;

import java.util.HashMap;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.adl.Reconfiguration;
import org.objectweb.dream.adl.ReconfigurationFactory;
import org.objectweb.dream.message.codec.CodecManager;
import org.objectweb.dream.message.codec.CodecManagerException;
import org.objectweb.dream.message.codec.CodecRepository;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.util.Fractal;

public class BasicCodecManagerImpl
extends AbstractComponent
implements CodecManager {
    public static final String CODECS_COMPONENT_ITF_NAME = "codecs-component";
    protected CodecRepository codecRepositoryItf;
    protected Component codecsCompositeItf;
    protected ContentController codecsCCItf;

    public void addCodec(String codecName, Object hints) throws CodecManagerException {
        Component codec = this.findCodec(codecName);
        if (codec != null) {
            return;
        }
        String codecADL = this.codecRepositoryItf.getCodecADL(codecName);
        if (codecADL == null) {
            throw new CodecManagerException(codecName, "Unknown codec.");
        }
        this.createCodec(codecName, codecADL, hints);
    }

    public void removeCodec(String codecName) throws CodecManagerException {
    }

    public Component getCodec(String codecName) throws CodecManagerException {
        Component codec = this.findCodec(codecName);
        if (codec == null) {
            throw new CodecManagerException(codecName, "Unknown codec");
        }
        return codec;
    }

    protected Component findCodec(String codecName) {
        Component[] codecs = this.codecsCCItf.getFcSubComponents();
        for (int i = 0; i < codecs.length; ++i) {
            String name;
            Component component = codecs[i];
            try {
                name = Fractal.getNameController(component).getFcName();
            }
            catch (NoSuchInterfaceException e) {
                break;
            }
            if (!codecName.equals(name)) continue;
            return component;
        }
        return null;
    }

    protected void createCodec(String codecName, String codecADL, Object hints) throws CodecManagerException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("codecName", codecName);
        try {
            Reconfiguration reconf = ReconfigurationFactory.getReconfiguration();
            reconf.addComponents(this.codecsCompositeItf, codecADL, context);
        }
        catch (ADLException e) {
            throw new CodecManagerException(codecName, "Unable to create codec caused by :" + e.toString());
        }
    }

    public String[] listFc() {
        return new String[]{"codec-repository", CODECS_COMPONENT_ITF_NAME};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (clientItfName.equals("codec-repository")) {
            this.codecRepositoryItf = (CodecRepository)serverItf;
        } else if (clientItfName.equals(CODECS_COMPONENT_ITF_NAME)) {
            this.codecsCompositeItf = (Component)serverItf;
            try {
                this.codecsCCItf = Fractal.getContentController(this.codecsCompositeItf);
            }
            catch (NoSuchInterfaceException e) {
                throw new IllegalBindingException("The codecs-component client interface must be bound to a composite component");
            }
        }
        super.bindFc(clientItfName, serverItf);
    }
}

