/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.protocol.causality;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.ExtensibleMessage;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.dream.protocol.ArrowChunk;
import org.objectweb.dream.protocol.causality.CausalityChunk;
import org.objectweb.dream.protocol.causality.CausalityTransformerAttributeController;
import org.objectweb.dream.protocol.causality.MatrixClock;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.util.monolog.api.BasicLevel;

public class InMessageSorterImpl
extends AbstractComponent
implements Push,
CausalityTransformerAttributeController {
    private MatrixClock matrixClockItf;
    private Push outPushItf;
    private MessageManager messageManagerItf;
    private List waitingToDeliver = new LinkedList();
    private String arrowChunkName;
    private String causalityChunkName;

    public void push(Message message, Map context) throws PushException {
        int todo;
        ArrowChunk arrowChunk = (ArrowChunk)message.getChunk(this.arrowChunkName);
        if (arrowChunk == null) {
            this.logger.log(BasicLevel.ERROR, (Object)("Unable to find arrow chunk named " + this.arrowChunkName + ". The message is dropped"));
            return;
        }
        CausalityChunk csltChunk = (CausalityChunk)message.getChunk(this.causalityChunkName);
        if (csltChunk == null) {
            this.logger.log(BasicLevel.ERROR, (Object)("Unable to find causality chunk named " + this.causalityChunkName + ". The message is dropped"));
        }
        if ((todo = this.matrixClockItf.testRecvMatrix(csltChunk.getCausalityStamp(), arrowChunk.getProcessIdFrom(), arrowChunk.getProcessIdTo())) == 0) {
            this.deliverMessage(message);
            boolean loop = true;
            block0: while (loop) {
                loop = false;
                Iterator iter = this.waitingToDeliver.iterator();
                while (iter.hasNext()) {
                    Message msg = (Message)iter.next();
                    ArrowChunk arrowChunk1 = (ArrowChunk)message.getChunk(this.arrowChunkName);
                    CausalityChunk csltChunk1 = (CausalityChunk)message.getChunk(this.causalityChunkName);
                    if (this.matrixClockItf.testRecvMatrix(csltChunk1.getCausalityStamp(), arrowChunk1.getProcessIdFrom(), arrowChunk.getProcessIdTo()) != 0) continue;
                    this.deliverMessage(msg);
                    iter.remove();
                    loop = true;
                    continue block0;
                }
            }
        } else if (todo == 1) {
            this.waitingToDeliver.add(message);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("block message " + message));
            }
        } else if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("message already delivred " + message));
        }
    }

    private void deliverMessage(Message message) throws PushException {
        if (message instanceof ExtensibleMessage) {
            Object causalityChunk = ((ExtensibleMessage)message).removeChunk(this.causalityChunkName);
            this.messageManagerItf.deleteChunk(causalityChunk);
        }
        this.outPushItf.push(message, null);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("deliver message " + message));
        }
    }

    public String getArrowChunkName() {
        return this.arrowChunkName;
    }

    public void setArrowChunkName(String arrowChunkName) {
        this.arrowChunkName = arrowChunkName;
    }

    public String getCausalityChunkName() {
        return this.causalityChunkName;
    }

    public void setCausalityChunkName(String causalityChunkName) {
        this.causalityChunkName = causalityChunkName;
    }

    public String[] listFc() {
        return new String[]{"out-push", "matrixClock", "message-manager"};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("matrixClock")) {
            this.matrixClockItf = (MatrixClock)serverItf;
        } else if (clientItfName.equals("out-push")) {
            this.outPushItf = (Push)serverItf;
        } else if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        }
    }
}

