/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.queue;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.dream.Pull;
import org.objectweb.dream.PullException;
import org.objectweb.dream.PushException;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.queue.AbstractPushQueueImpl;
import org.objectweb.dream.queue.KeyNotFoundException;
import org.objectweb.dream.queue.PushPullKeyQueueAttributeController;
import org.objectweb.dream.util.EmptyStringArray;

public class BasicPushPullKeyQueueImpl
extends AbstractPushQueueImpl
implements Pull,
PushPullKeyQueueAttributeController {
    public static final String KEY_CONTEXT = "key";
    String messageNotFoundPolicy;
    String keyChunkName;
    Map waitingMap = new HashMap();

    public synchronized void push(Message message, Map context) throws PushException {
        this.handleOverflow();
        this.waitingList.add(message);
        this.notify();
    }

    public Message pull(Map context) throws PullException {
        Object key = context.get(KEY_CONTEXT);
        if (key == null) {
            throw new PullException("Unable to find key object in the context");
        }
        Message msg = (Message)this.waitingMap.get(key);
        if (msg == null) {
            return this.handlePolicy(key);
        }
        return msg;
    }

    protected Message handlePolicy(Object key) throws KeyNotFoundException {
        if (this.messageNotFoundPolicy == "return-null") {
            return null;
        }
        if (this.messageNotFoundPolicy == "exception") {
            throw new KeyNotFoundException(key);
        }
        return null;
    }

    public String getMessageNotFoundPolicy() {
        return this.messageNotFoundPolicy;
    }

    public void setMessageNotFoundPolicy(String policy) {
        if ("return-null".equals(policy)) {
            this.messageNotFoundPolicy = "return-null";
        } else if ("exception".equals(policy)) {
            this.messageNotFoundPolicy = "exception";
        } else {
            throw new IllegalArgumentException("Unknown \"message not found\" policy : " + policy);
        }
    }

    public String getKeyName() {
        return this.keyChunkName;
    }

    public void setKeyName(String name) {
        this.keyChunkName = name;
    }

    public String[] listFc() {
        return EmptyStringArray.EMPTY_STRING_ARRAY;
    }
}

