/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.types;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentDefinition;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterface;

public class TypeLoader
extends AbstractLoader {
    public Definition load(String name, Map context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        boolean extend = false;
        if (d instanceof ComponentDefinition) {
            extend = ((ComponentDefinition)d).getExtends() != null;
        }
        this.checkNode(d, extend, context);
        return d;
    }

    private void checkNode(Object node, boolean extend, Map context) throws ADLException {
        if (node instanceof InterfaceContainer) {
            this.checkInterfaceContainer((InterfaceContainer)node, extend, context);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps = ((ComponentContainer)node).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.checkNode(comps[i], extend, context);
            }
        }
    }

    private void checkInterfaceContainer(InterfaceContainer container, boolean extend, Map context) throws ADLException {
        Interface[] itfs = container.getInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            String contingency;
            String role;
            Interface itf = itfs[i];
            if (!(itf instanceof TypeInterface)) continue;
            String signature = ((TypeInterface)itf).getSignature();
            if (signature == null) {
                if (!extend) {
                    throw new ADLException("Signature missing", (Node)((Object)itf));
                }
            } else {
                try {
                    this.getClassLoader(context).loadClass(signature);
                }
                catch (ClassNotFoundException e) {
                    throw new ADLException("Invalid signature '" + signature + "'", (Node)((Object)itf), e);
                }
            }
            if ((role = ((TypeInterface)itf).getRole()) == null) {
                if (!extend) {
                    throw new ADLException("Role missing", (Node)((Object)itf));
                }
            } else if (!role.equals("client") && !role.equals("server")) {
                throw new ADLException("Invalid role '" + role + "'", (Node)((Object)itf));
            }
            if ((contingency = ((TypeInterface)itf).getContingency()) != null && !contingency.equals("mandatory") && !contingency.equals("optional")) {
                throw new ADLException("Invalid contingency '" + contingency + "'", (Node)((Object)itf));
            }
            String cardinality = ((TypeInterface)itf).getCardinality();
            if (cardinality == null || cardinality.equals("singleton") || cardinality.equals("collection")) continue;
            throw new ADLException("Invalid cardinality '" + cardinality + "'", (Node)((Object)itf));
        }
    }
}

