/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.asm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.fractal.julia.asm.ClassGenerationException;
import org.objectweb.fractal.julia.asm.ClassGenerator;
import org.objectweb.fractal.julia.loader.Loader;
import org.objectweb.fractal.julia.loader.Tree;

public abstract class AbstractClassGenerator
implements ClassGenerator,
Opcodes {
    public ClassWriter cw;
    public String name;
    public String superClass;
    public List interfaces;
    public String parameters;
    public Loader loader;
    public ClassLoader classLoader;
    static /* synthetic */ Class class$org$objectweb$fractal$julia$loader$Generated;

    public byte[] generateClass(String name, Tree args, Loader loader, ClassLoader classLoader) throws ClassGenerationException {
        this.name = name.replace('.', '/');
        this.parameters = args.toString();
        this.loader = loader;
        this.classLoader = classLoader;
        this.cw = new ClassWriter(this.computeMaxs());
        this.parseArgs(args);
        this.generateHeader();
        this.generateConstructor();
        this.generateDefaultMethods();
        this.generateInterfaceMethods();
        return this.cw.toByteArray();
    }

    protected void parseArgs(Tree args) {
        this.superClass = args.getSubTree(1).toString().replace('.', '/');
        this.interfaces = new ArrayList<Tree>(Arrays.asList(args.getSubTree(2).getSubTrees()));
        for (int i = 0; i < this.interfaces.size(); ++i) {
            this.interfaces.set(i, this.interfaces.get(i).toString().replace('.', '/'));
        }
    }

    protected boolean computeMaxs() {
        return false;
    }

    protected void generateHeader() throws ClassGenerationException {
        int access = 1;
        List itfList = this.getImplementedInterfaces();
        String[] itfs = itfList.toArray(new String[itfList.size()]);
        this.cw.visit(196653, access, this.name, null, this.superClass, itfs);
        this.cw.visitSource(this.getSource(), null);
    }

    protected String getSource() {
        return "GENERATED";
    }

    protected List getImplementedInterfaces() throws ClassGenerationException {
        ArrayList<String> itfs = new ArrayList<String>(this.interfaces);
        itfs.add(Type.getInternalName(class$org$objectweb$fractal$julia$loader$Generated == null ? (class$org$objectweb$fractal$julia$loader$Generated = AbstractClassGenerator.class$("org.objectweb.fractal.julia.loader.Generated")) : class$org$objectweb$fractal$julia$loader$Generated));
        return itfs;
    }

    protected void generateConstructor() throws ClassGenerationException {
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.superClass, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    protected void generateDefaultMethods() throws ClassGenerationException {
        String name = "getFcGeneratorParameters";
        String desc = "()Ljava/lang/String;";
        MethodVisitor mv = this.cw.visitMethod(1, name, desc, null, null);
        mv.visitCode();
        mv.visitLdcInsn(this.parameters);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    protected void generateInterfaceMethods() throws ClassGenerationException {
        ArrayList<String> generated = new ArrayList<String>();
        for (int i = 0; i < this.interfaces.size(); ++i) {
            Class itf;
            String s = ((String)this.interfaces.get(i)).replace('/', '.');
            try {
                itf = this.loader.loadClass(s, (Object)this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new ClassGenerationException(e, this.parameters, "Cannot load the '" + s + "' interface");
            }
            Method[] meths = itf.getMethods();
            for (int j = 0; j < meths.length; ++j) {
                Method meth = meths[j];
                String desc = meth.getName() + Type.getMethodDescriptor(meth);
                if (generated.contains(desc)) continue;
                this.generateMethod(meth);
                generated.add(desc);
            }
        }
    }

    protected abstract void generateMethod(Method var1) throws ClassGenerationException;

    public static int getOpcodeOffset(Class type) {
        if (type == Double.TYPE) {
            return 3;
        }
        if (type == Float.TYPE) {
            return 2;
        }
        if (type == Long.TYPE) {
            return 1;
        }
        if (type.isPrimitive()) {
            return 0;
        }
        return 4;
    }

    public static int getSize(Class type) {
        return type == Double.TYPE || type == Long.TYPE ? 2 : 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

