/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.loader;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.julia.loader.Generated;
import org.objectweb.fractal.julia.loader.Initializable;
import org.objectweb.fractal.julia.loader.Loader;
import org.objectweb.fractal.julia.loader.Tree;

public class BasicLoader
implements Loader {
    private String config;
    private boolean checkClassParameters;
    private String genPkg;
    private Map definitions;
    private InputStream is;
    private int line;
    private int car;

    public void init(Map context) throws Exception {
        if (context.get("julia.config") != null) {
            this.config = (String)context.get("julia.config");
        } else if (System.getProperty("julia.config") != null) {
            this.config = System.getProperty("julia.config");
        } else {
            throw new Exception("The julia.config system property is not defined");
        }
        if (context.get("julia.loader.check") != null) {
            this.checkClassParameters = true;
        } else if (System.getProperty("julia.loader.check") != null) {
            this.checkClassParameters = true;
        }
        this.genPkg = "org.objectweb.fractal.julia.generated";
        if (context.get("julia.loader.gen.pkg") != null) {
            this.genPkg = (String)context.get("julia.loader.gen.pkg");
        } else if (System.getProperty("julia.loader.gen.pkg") != null) {
            this.genPkg = System.getProperty("julia.loader.gen.pkg");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree loadTree(String name) throws Exception {
        Tree t;
        if (this.definitions == null) {
            int i;
            this.definitions = new HashMap();
            int b = 0;
            block11: do {
                InputStream is;
                String file;
                block18: {
                    if ((i = this.config.indexOf(44, b)) == -1) {
                        file = this.config.substring(b);
                    } else {
                        file = this.config.substring(b, i);
                        b = i + 1;
                    }
                    try {
                        is = this.getInputStream(file);
                    }
                    catch (IOException ioe) {
                        is = this.getClass().getResourceAsStream("/" + file);
                        if (is != null) break block18;
                        throw new Exception("Cannot find or open the '" + file + "' file");
                    }
                }
                try {
                    this.line = 1;
                    while (true) {
                        Tree def;
                        try {
                            def = this.parseTree(is);
                        }
                        catch (Throwable e) {
                            throw new Exception("File '" + file + "', line " + this.line + ": " + e.getMessage());
                        }
                        if (def == null) {
                            continue block11;
                        }
                        this.definitions.put(def.getSubTree(0).toString(), def.getSubTree(1));
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException ignored) {}
                }
            } while (i != -1);
        }
        if ((t = (Tree)this.definitions.get(name)) == null) {
            throw new Exception("Cannot find the '" + name + "' descriptor in the '" + this.config + "' file(s) specified in the julia.loader.config system property");
        }
        return t;
    }

    public Tree evalTree(Tree tree, Map context) throws Exception {
        if (tree.getSize() == 0) {
            String var = tree.toString();
            if (var.startsWith("'")) {
                Tree val = (Tree)context.get(var = var.substring(1));
                if (val == null) {
                    val = this.loadTree(var);
                }
                if (val == null) {
                    throw new Exception(var);
                }
                if (!val.toString().equals("QUOTE")) {
                    return this.evalTree(val, context);
                }
            }
            return tree;
        }
        boolean ok = true;
        Tree[] subTrees = tree.getSubTrees();
        for (int i = 0; i < subTrees.length; ++i) {
            Tree oldSubTree = subTrees[i];
            Tree newSubTree = this.evalTree(oldSubTree, context);
            if (newSubTree == oldSubTree) continue;
            if (ok) {
                Tree[] newSubTrees = new Tree[subTrees.length];
                System.arraycopy(subTrees, 0, newSubTrees, 0, subTrees.length);
                subTrees = newSubTrees;
                ok = false;
            }
            subTrees[i] = newSubTree;
        }
        return ok ? tree : new Tree(subTrees);
    }

    public Object newObject(Tree objectDescriptor, Object loader) throws Exception {
        if (objectDescriptor.getSize() == 0) {
            return this.loadClass(objectDescriptor.toString(), loader).newInstance();
        }
        Object o = this.loadClass(objectDescriptor.getSubTree(0), loader).newInstance();
        if (objectDescriptor.getSize() > 1) {
            Tree[] trees = objectDescriptor.getSubTrees();
            Tree[] args = new Tree[trees.length - 1];
            System.arraycopy(trees, 1, args, 0, args.length);
            ((Initializable)o).initialize(new Tree(args));
        }
        return o;
    }

    public Class loadClass(String name, Object loader) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public Class loadClass(Tree classDescriptor, Object loader) throws ClassNotFoundException {
        if (classDescriptor.getSize() == 0) {
            return this.loadClass(classDescriptor.toString(), loader);
        }
        int n = 0;
        String s = this.genPkg + ".C" + Integer.toHexString(classDescriptor.hashCode()) + "_";
        while (true) {
            Class c;
            String name = s + n;
            try {
                c = this.loadClass(name, loader);
            }
            catch (ClassNotFoundException e) {
                return this.generateClass(name, classDescriptor, loader);
            }
            if (!this.checkClassParameters) {
                return c;
            }
            try {
                Generated gen = (Generated)c.newInstance();
                if (gen != null && classDescriptor.equals(gen.getFcGeneratorParameters())) {
                    return c;
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            ++n;
        }
    }

    private InputStream getInputStream(String file) throws IOException {
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tree parseTree(InputStream is) throws Exception {
        try {
            this.is = is;
            this.read();
            this.parseSpaces();
            if (this.car == -1) {
                Tree tree = null;
                return tree;
            }
            Tree tree = this.parseTree();
            return tree;
        }
        finally {
            this.is = null;
        }
    }

    private Tree parseTree() throws IOException, Exception {
        int c = this.car;
        if (c == -1) {
            throw new Exception("Unexpected end of file");
        }
        if (c == 41) {
            throw new Exception("Unmatched closing parenthesis");
        }
        if (c == 40) {
            this.read();
            ArrayList<Tree> subTrees = new ArrayList<Tree>();
            while (true) {
                if ((c = this.parseSpaces()) == 41) {
                    this.read();
                    return new Tree(subTrees.toArray(new Tree[subTrees.size()]));
                }
                subTrees.add(this.parseTree());
            }
        }
        StringBuffer buf = new StringBuffer();
        do {
            buf.append((char)c);
        } while ((c = this.read()) != -1 && c != 32 && c != 9 && c != 10 && c != 13 && c != 35 && c != 40 && c != 41);
        this.car = c;
        return new Tree(buf.toString());
    }

    private int parseSpaces() throws IOException {
        int c = this.car;
        while (c == 32 || c == 9 || c == 10 || c == 13 || c == 35) {
            if (c == 35) {
                while ((c = this.read()) != 10 && c != 13) {
                }
            }
            c = this.read();
        }
        this.car = c;
        return this.car;
    }

    private int read() throws IOException {
        this.car = this.is.read();
        if (this.car == 10 || this.car == 13) {
            ++this.line;
        }
        return this.car;
    }

    protected Class generateClass(String name, Tree classDescriptor, Object loader) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }
}

