/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.type;

import java.io.Serializable;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.type.InterfaceType;

public class BasicInterfaceType
implements InterfaceType,
Serializable {
    private static final int CLIENT_FLAG = 1;
    private static final int OPTIONAL_FLAG = 2;
    private static final int COLLECTION_FLAG = 4;
    private String name;
    private String signature;
    private int flags;

    public BasicInterfaceType(String name, String signature, boolean isClient, boolean isOptional, boolean isCollection) {
        int flags = 0;
        flags = isClient ? flags | 1 : flags;
        flags = isOptional ? flags | 2 : flags;
        flags = isCollection ? flags | 4 : flags;
        this.name = name;
        this.signature = signature;
        this.flags = flags;
    }

    public String getFcItfName() {
        return this.name;
    }

    public String getFcItfSignature() {
        return this.signature;
    }

    public boolean isFcClientItf() {
        return (this.flags & 1) != 0;
    }

    public boolean isFcOptionalItf() {
        return (this.flags & 2) != 0;
    }

    public boolean isFcCollectionItf() {
        return (this.flags & 4) != 0;
    }

    public boolean isFcSubTypeOf(Type type) {
        if (type instanceof InterfaceType) {
            InterfaceType t = (InterfaceType)type;
            if (t.isFcClientItf() != this.isFcClientItf()) {
                return false;
            }
            if (!t.getFcItfName().equals(this.getFcItfName())) {
                return false;
            }
            if (t.isFcCollectionItf() && !this.isFcCollectionItf()) {
                return false;
            }
            if (this.isFcClientItf() ? t.isFcOptionalItf() && !this.isFcOptionalItf() : !t.isFcOptionalItf() && this.isFcOptionalItf()) {
                return false;
            }
            if (t.getFcItfSignature().equals(this.getFcItfSignature())) {
                return true;
            }
            if (t instanceof BasicInterfaceType) {
                try {
                    Class<?> c1 = Class.forName(this.signature);
                    Class<?> c2 = Class.forName(((BasicInterfaceType)t).signature);
                    if (c1 != null && c2 != null && this.isFcClientItf()) {
                        return c1.isAssignableFrom(c2);
                    }
                    return c2.isAssignableFrom(c1);
                }
                catch (ClassNotFoundException e) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof InterfaceType) {
            InterfaceType type = (InterfaceType)o;
            if (this.getFcItfName().equals(type.getFcItfName()) && this.isFcClientItf() == type.isFcClientItf() && this.isFcOptionalItf() == type.isFcOptionalItf() && this.isFcCollectionItf() == type.isFcCollectionItf() && (this.getFcItfName().equals("attribute-controller") || this.getFcItfSignature().equals(type.getFcItfSignature()))) {
                return true;
            }
        }
        return false;
    }
}

