/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.filtering;

import org.objectweb.lewys.filtering.CacheFilter;
import org.objectweb.lewys.filtering.Filter;
import org.objectweb.lewys.filtering.LinearFilter;
import org.objectweb.lewys.filtering.SignalPoint;

public class CacheLinearFilter
extends Filter {
    private CacheFilter cacheFilter;
    private LinearFilter linearFilter;
    private int usedFilter;
    private static final int BOTH = 0;
    private static final int CACHE = 1;
    private static final int LINEAR = 2;

    public CacheLinearFilter() {
        this(0.0);
    }

    public CacheLinearFilter(double precisionWidth) {
        this.precisionWidth = precisionWidth;
        this.usedFilter = 0;
        this.cacheFilter = new CacheFilter(precisionWidth);
        this.linearFilter = new LinearFilter(precisionWidth);
    }

    public SignalPoint[] getKeyPoint(SignalPoint point) {
        ++this.observedPointsCount;
        SignalPoint[] cachePoint = null;
        SignalPoint[] linearPoint = null;
        if (this.usedFilter == 0) {
            cachePoint = this.cacheFilter.getKeyPoint(point);
            linearPoint = this.linearFilter.getKeyPoint(point);
        } else if (this.usedFilter == 1) {
            cachePoint = this.cacheFilter.getKeyPoint(point);
            linearPoint = cachePoint;
        } else if (this.usedFilter == 2) {
            linearPoint = this.linearFilter.getKeyPoint(point);
            cachePoint = linearPoint;
        }
        if (cachePoint == null && linearPoint == null) {
            return null;
        }
        if (cachePoint == null && linearPoint != null) {
            this.usedFilter = 1;
            return null;
        }
        if (cachePoint != null && linearPoint == null) {
            this.usedFilter = 2;
            return null;
        }
        if (cachePoint != null && linearPoint != null) {
            this.usedFilter = 0;
            this.cacheFilter.reset(point);
            this.linearFilter.reset(linearPoint[0], point);
            if (this.observedPointsCount == 1) {
                this.firstTime = (long)linearPoint[0].getTime();
            }
            this.lastTime = (long)linearPoint[0].getTime();
            return linearPoint;
        }
        return null;
    }
}

