/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.filtering;

import java.util.ArrayList;
import org.objectweb.lewys.filtering.Filter;
import org.objectweb.lewys.filtering.SignalPoint;

public class SlideFilter
extends Filter {
    private ArrayList firstPoints = new ArrayList();
    public static final int FIRST_POINTS_LIMIT = 10000;
    private SignalPoint lastPoint = null;
    private SignalPoint lastPoint1 = null;
    private double au;
    private double bu;
    private double al;
    private double bl;
    private double au1;
    private double bu1;
    private double al1;
    private double bl1;
    private double as1;
    private double bs1;
    private boolean initializing;
    private boolean optimizerOn = true;
    private int selectedEnvelope;
    private static final int UPPER_ONLY = 1;
    private static final int ALL_RANGE = 2;
    private double doublePrecisionWidth;

    public SlideFilter() {
        this(0.0);
    }

    public SlideFilter(double precisionWidth) {
        this.precisionWidth = precisionWidth;
        this.doublePrecisionWidth = 2.0 * precisionWidth;
        this.selectedEnvelope = 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public SignalPoint[] getKeyPoint(SignalPoint point) {
        SignalPoint[] recordings;
        int arraySize;
        ++this.observedPointsCount;
        double maxValue = 0.0;
        double minValue = 0.0;
        double value = point.getValue();
        boolean keyPointFound = false;
        SignalPoint firstPoint = null;
        if (this.optimizerOn && point.getTime() == 36.0 && Math.abs(this.precisionWidth - 2.02) < 1.0E-7) {
            System.out.println("err");
        }
        if ((arraySize = this.firstPoints.size()) == 0) {
            this.firstPoints.add(point);
            this.lastPoint = point;
            this.au = Double.MAX_VALUE;
            this.bu = 0.0;
            this.al = -1.7976931348623157E308;
            this.bl = 0.0;
            this.initializing = true;
            this.lastTime = this.firstTime = (long)point.getTime();
            return null;
        }
        if (this.selectedEnvelope == 1) {
            maxValue = this.au * point.getTime() + this.bu + this.precisionWidth;
            minValue = this.al * point.getTime() + this.bl - this.precisionWidth;
            if (!(value > maxValue) && !(value < minValue)) {
                this.lastPoint = point;
                return null;
            }
            keyPointFound = true;
        } else if (this.selectedEnvelope == 2) {
            maxValue = this.au * point.getTime() + this.bu + this.precisionWidth;
            minValue = this.al * point.getTime() + this.bl - this.precisionWidth;
            if (value > maxValue || value < minValue) {
                keyPointFound = true;
            } else {
                SignalPoint checkedPoint;
                int i;
                double pointTimePlus1 = point.getTime() + 1.0;
                if (value < maxValue - this.doublePrecisionWidth) {
                    for (i = 0; i < arraySize; ++i) {
                        double futureValueu;
                        double bui;
                        checkedPoint = (SignalPoint)this.firstPoints.get(i);
                        double aui = (point.getValue() - checkedPoint.getValue() + this.doublePrecisionWidth) / (point.getTime() - checkedPoint.getTime());
                        double futureValueui = aui * pointTimePlus1 + (bui = checkedPoint.getValue() - aui * checkedPoint.getTime() - this.precisionWidth);
                        if (!(futureValueui < (futureValueu = this.au * pointTimePlus1 + this.bu))) continue;
                        this.au = aui;
                        this.bu = bui;
                    }
                }
                if (value > minValue + this.doublePrecisionWidth) {
                    for (i = 0; i < arraySize; ++i) {
                        double futureValuel;
                        double bli;
                        checkedPoint = (SignalPoint)this.firstPoints.get(i);
                        double ali = (point.getValue() - checkedPoint.getValue() - this.doublePrecisionWidth) / (point.getTime() - checkedPoint.getTime());
                        double futureValueli = ali * pointTimePlus1 + (bli = checkedPoint.getValue() - ali * checkedPoint.getTime() + this.precisionWidth);
                        if (!(futureValueli > (futureValuel = this.al * pointTimePlus1 + this.bl))) continue;
                        this.al = ali;
                        this.bl = bli;
                    }
                }
                if (arraySize == 10000) {
                    this.selectedEnvelope = 1;
                } else {
                    this.firstPoints.add(point);
                }
                this.lastPoint = point;
                return null;
            }
        }
        if (!keyPointFound) {
            return null;
        }
        if (this.optimizerOn && point.getTime() == 35.0) {
            System.out.println("err");
        }
        if (this.initializing) {
            this.au1 = this.au;
            this.bu1 = this.bu;
            this.al1 = this.al;
            this.bl1 = this.bl;
            firstPoint = (SignalPoint)this.firstPoints.get(0);
            this.as1 = this.au;
            this.bs1 = this.bu;
            double firstTime = firstPoint.getTime();
            double firstValueu = this.au * firstTime + this.bu;
            this.firstPoints.clear();
            this.firstPoints.add(point);
            this.lastPoint1 = this.lastPoint;
            this.lastPoint = point;
            this.au = Double.MAX_VALUE;
            this.bu = 0.0;
            this.al = -1.7976931348623157E308;
            this.bl = 0.0;
            this.initializing = false;
            return new SignalPoint[]{new SignalPoint(firstTime, firstValueu)};
        }
        double lastPoint1Time = this.lastPoint1.getTime();
        double pastValueu = this.au * lastPoint1Time + this.bu;
        double pastValueu1 = this.au1 * lastPoint1Time + this.bu1;
        double pastValuel = this.al * lastPoint1Time + this.bl;
        double pastValuel1 = this.al1 * lastPoint1Time + this.bl1;
        firstPoint = (SignalPoint)this.firstPoints.get(0);
        double maxValue1 = this.au1 * firstPoint.getTime() + this.bu1 + this.precisionWidth;
        double minValue1 = this.al1 * firstPoint.getTime() + this.bl1 - this.precisionWidth;
        double value1 = firstPoint.getValue();
        if (value1 > maxValue1 && pastValueu < pastValueu1 && this.optimizerOn) {
            double timeus1 = (this.bs1 - this.bu) / (this.au - this.as1);
            double valueus1 = this.au * timeus1 + this.bu;
            recordings = new SignalPoint[]{new SignalPoint(timeus1, valueus1)};
            this.as1 = this.au;
            this.bs1 = this.bu;
        } else if (value1 < minValue1 && pastValuel > pastValuel1 && this.optimizerOn) {
            double timels1 = (this.bs1 - this.bl) / (this.al - this.as1);
            double valuels1 = this.al * timels1 + this.bl;
            recordings = new SignalPoint[]{new SignalPoint(timels1, valuels1)};
            this.as1 = this.al;
            this.bs1 = this.bl;
        } else {
            double pastTimes1 = lastPoint1Time;
            double pastValues1 = this.as1 * lastPoint1Time + this.bs1;
            firstPoint = (SignalPoint)this.firstPoints.get(0);
            double firstTime = firstPoint.getTime();
            double firstValueu = this.au * firstTime + this.bu;
            recordings = new SignalPoint[]{new SignalPoint(pastTimes1, pastValues1), new SignalPoint(firstTime, firstValueu)};
            this.as1 = this.au;
            this.bs1 = this.bu;
        }
        this.au1 = this.au;
        this.bu1 = this.bu;
        this.al1 = this.al;
        this.bl1 = this.bl;
        this.firstPoints.clear();
        this.firstPoints.add(point);
        this.lastPoint1 = this.lastPoint;
        this.lastPoint = point;
        this.au = Double.MAX_VALUE;
        this.bu = 0.0;
        this.al = -1.7976931348623157E308;
        this.bl = 0.0;
        this.lastTime = (long)((SignalPoint)this.firstPoints.get(this.firstPoints.size() - 1)).getTime();
        return recordings;
    }

    public void reset(SignalPoint firstPoint, SignalPoint secondPoint) {
        this.firstPoints.clear();
        this.firstPoints.add(firstPoint);
        this.firstPoints.add(secondPoint);
        this.lastPoint = secondPoint;
        this.selectedEnvelope = 2;
    }

    public void setOptimizerOn(boolean optimizerOn) {
        this.optimizerOn = optimizerOn;
    }
}

