/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.filtering;

import org.objectweb.lewys.filtering.Filter;
import org.objectweb.lewys.filtering.SignalPoint;

public class SwingFilter
extends Filter {
    private SignalPoint firstPoint = null;
    private SignalPoint lastPoint = null;
    private double maxSlope;
    private double minSlope;
    private boolean optimizerOn = true;
    private double doublePrecisionWidth;

    public SwingFilter() {
        this(0.0);
    }

    public SwingFilter(double precisionWidth) {
        this.precisionWidth = precisionWidth;
        this.doublePrecisionWidth = 2.0 * precisionWidth;
    }

    public SignalPoint[] getKeyPoint(SignalPoint point) {
        ++this.observedPointsCount;
        if (this.firstPoint == null) {
            this.firstPoint = point;
            this.lastPoint = point;
            this.maxSlope = Double.MAX_VALUE;
            this.minSlope = -1.7976931348623157E308;
            this.lastTime = this.firstTime = (long)this.firstPoint.getTime();
            return new SignalPoint[]{this.firstPoint};
        }
        double diffTime = point.getTime() - this.firstPoint.getTime();
        double firstPointValue = this.firstPoint.getValue();
        double maxValue = firstPointValue + this.maxSlope * diffTime + this.precisionWidth;
        double minValue = firstPointValue + this.minSlope * diffTime - this.precisionWidth;
        double pointValue = point.getValue();
        if (pointValue > maxValue) {
            double au = this.maxSlope;
            double bu = firstPointValue - this.maxSlope * this.firstPoint.getTime();
            if (this.optimizerOn) {
                double foo = pointValue - au * point.getTime() - bu;
                double t = Math.max(this.lastPoint.getTime(), point.getTime() - Math.sqrt(foo * foo - this.precisionWidth * this.precisionWidth));
                double x = au * t + bu;
                this.firstPoint = new SignalPoint(t, x);
            } else {
                double lastFirstDiffTime = this.lastPoint.getTime() - this.firstPoint.getTime();
                double lastMaxValue = firstPointValue + this.maxSlope * lastFirstDiffTime + this.precisionWidth;
                double maxWidthDiff = lastMaxValue - this.precisionWidth;
                if (this.lastPoint.getValue() > maxWidthDiff) {
                    this.firstPoint = new SignalPoint(this.lastPoint.getTime(), maxWidthDiff);
                } else {
                    double lastMinValue = firstPointValue + this.minSlope * lastFirstDiffTime - this.precisionWidth;
                    double minWidthDiff = lastMinValue + this.precisionWidth;
                    this.firstPoint = this.lastPoint.getValue() < minWidthDiff ? new SignalPoint(this.lastPoint.getTime(), minWidthDiff) : this.lastPoint;
                }
            }
            this.lastPoint = point;
            double diffValue = pointValue - this.firstPoint.getValue();
            double pointFirstDiffTime = point.getTime() - this.firstPoint.getTime();
            this.maxSlope = (diffValue + this.precisionWidth) / pointFirstDiffTime;
            this.minSlope = (diffValue - this.precisionWidth) / pointFirstDiffTime;
            this.lastTime = (long)this.firstPoint.getTime();
            return new SignalPoint[]{this.firstPoint};
        }
        if (pointValue < minValue) {
            double al = this.minSlope;
            double bl = firstPointValue - this.minSlope * this.firstPoint.getTime();
            if (this.optimizerOn) {
                double foo = pointValue - al * point.getTime() - bl;
                double t = Math.max(this.lastPoint.getTime(), point.getTime() - Math.sqrt(foo * foo - this.precisionWidth * this.precisionWidth));
                double x = al * t + bl;
                this.firstPoint = new SignalPoint(t, x);
            } else {
                double lastFirstDiffTime = this.lastPoint.getTime() - this.firstPoint.getTime();
                double lastMaxValue = firstPointValue + this.maxSlope * lastFirstDiffTime + this.precisionWidth;
                double maxWidthDiff = lastMaxValue - this.precisionWidth;
                if (this.lastPoint.getValue() > maxWidthDiff) {
                    this.firstPoint = new SignalPoint(this.lastPoint.getTime(), maxWidthDiff);
                } else {
                    double lastMinValue = firstPointValue + this.minSlope * lastFirstDiffTime - this.precisionWidth;
                    double minWidthDiff = lastMinValue + this.precisionWidth;
                    this.firstPoint = this.lastPoint.getValue() < minWidthDiff ? new SignalPoint(this.lastPoint.getTime(), minWidthDiff) : this.lastPoint;
                }
            }
            this.lastPoint = point;
            double diffValue = pointValue - this.firstPoint.getValue();
            double pointFirstDiffTime = point.getTime() - this.firstPoint.getTime();
            this.maxSlope = (diffValue + this.precisionWidth) / pointFirstDiffTime;
            this.minSlope = (diffValue - this.precisionWidth) / pointFirstDiffTime;
            this.lastTime = (long)this.firstPoint.getTime();
            return new SignalPoint[]{this.firstPoint};
        }
        double diffValue = pointValue - this.firstPoint.getValue();
        if (pointValue > minValue + this.doublePrecisionWidth) {
            this.minSlope = (diffValue - this.precisionWidth) / diffTime;
        }
        if (pointValue < maxValue - this.doublePrecisionWidth) {
            this.maxSlope = (diffValue + this.precisionWidth) / diffTime;
        }
        this.lastPoint = point;
        return null;
    }

    public void reset(SignalPoint firstPoint, SignalPoint secondPoint) {
        this.firstPoint = firstPoint;
        this.lastPoint = secondPoint;
        double diffValue = secondPoint.getValue() - firstPoint.getValue();
        double diffTime = secondPoint.getTime() - firstPoint.getTime();
        this.minSlope = (diffValue - this.precisionWidth) / diffTime;
        this.maxSlope = (diffValue + this.precisionWidth) / diffTime;
    }

    public void setOptimizerOn(boolean optimizerOn) {
        this.optimizerOn = optimizerOn;
    }
}

