/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Pull;
import org.objectweb.dream.PullException;
import org.objectweb.dream.message.BasicMessageType;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.MessageType;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.dream.time.GetTimeStamp;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.message.MonitoringValueChunk;
import org.objectweb.lewys.probe.Probe;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class AbstractProbe
extends AbstractComponent
implements Probe,
Pull,
NameController,
Serializable {
    private String name;
    protected int[] resourceIds;
    protected String[] resourceNames;
    protected MessageManager messageManagerItf;
    protected GetTimeStamp getTimeStamp;
    protected static final MessageType TYPE = new BasicMessageType("monitoring-value-chunk", MonitoringValueChunk.TYPE);

    public AbstractProbe(String probeName) {
        this.name = probeName;
    }

    public int[] getResourceIds() {
        return this.resourceIds;
    }

    public String[] getResourceNames() {
        return this.resourceNames;
    }

    public int getResourceId(String resourceName) throws NoSuchResourceException {
        for (int i = 0; i < this.resourceNames.length; ++i) {
            if (!this.resourceNames[i].equalsIgnoreCase(resourceName)) continue;
            return i;
        }
        throw new NoSuchResourceException();
    }

    public String getResourceName(int resourceId) throws NoSuchResourceException {
        try {
            return this.resourceNames[resourceId];
        }
        catch (RuntimeException e) {
            throw new NoSuchResourceException();
        }
    }

    public Message pull(Map context) throws PullException {
        long[] values;
        int[] resourceIds = (int[])context.get("resourceIds");
        if (resourceIds == null) {
            resourceIds = this.getResourceIds();
        }
        try {
            values = this.getValue(resourceIds);
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.ERROR, (Object)"Unable to probe", (Throwable)e);
            return null;
        }
        Message m = this.messageManagerItf.createMessage(TYPE);
        MonitoringValueChunk chunk = (MonitoringValueChunk)m.getChunk("monitoring-value-chunk");
        chunk.setProbeName(this.name);
        chunk.setResourceIds(resourceIds);
        chunk.setValues(values);
        chunk.setTimestamp(this.getTimeStamp.getTimeStamp());
        try {
            chunk.setSenderName(InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            this.logger.log(BasicLevel.ERROR, (Object)"Unable to get host IP address", (Throwable)e);
            return null;
        }
        return m;
    }

    public String getFcName() {
        return this.name;
    }

    public void setFcName(String fcName) {
        this.name = fcName;
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        } else if (clientItfName.equals("get-time-stamp")) {
            this.getTimeStamp = (GetTimeStamp)serverItf;
        }
    }

    public String[] listFc() {
        return new String[]{"message-manager", "get-time-stamp"};
    }
}

