/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.linux;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class DiskProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESSOURCES = 11;
    private long[] readsIssued;
    private long[] readsMerged;
    private long[] readSectors;
    private long[] readTimeInMs;
    private long[] writesIssued;
    private long[] writesMerged;
    private long[] writeSectors;
    private long[] writeTimeInMs;
    private long[] ioInProgress;
    private long[] ioInMs;
    private long[] averageIoMs;
    private int nbOfDisks = 0;
    private RandomAccessFile procFile;
    private byte[] buffer;
    private static NoResourceToProbeException invalidFileFormat = new NoResourceToProbeException("Invalid /proc/partitions file format for this probe.");
    private static final int BUFFER_SIZE = 4096;
    private int[] index;

    public DiskProbe() throws NoResourceToProbeException {
        super("disk probe");
        int i;
        try {
            this.procFile = new RandomAccessFile("/proc/partitions", "r");
            this.buffer = new byte[4096];
            this.procFile.read(this.buffer);
            i = 0;
            while (this.buffer[i] != 10) {
                ++i;
            }
            ++i;
            while (this.buffer[i] != 10) {
                ++i;
            }
            ++i;
            do {
                for (int cpuStat = 0; cpuStat < 3; ++cpuStat) {
                    while (this.buffer[i] == 32) {
                        ++i;
                    }
                    while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                        ++i;
                    }
                    if (this.buffer[i] == 32) continue;
                    throw invalidFileFormat;
                }
                while (this.buffer[i] == 32) {
                    ++i;
                }
                while (this.buffer[i] != 32) {
                    ++i;
                }
                for (int diskStat = 0; diskStat < 11; ++diskStat) {
                    while (this.buffer[i] == 32) {
                        ++i;
                    }
                    if (this.buffer[i] == 45) {
                        ++i;
                    }
                    while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                        ++i;
                    }
                    if (this.buffer[i] == 32 || this.buffer[i] == 10 || this.buffer[i] == 13) continue;
                    throw invalidFileFormat;
                }
                while (this.buffer[i] != 10 && i < 4096) {
                    ++i;
                }
                ++this.nbOfDisks;
            } while (++i < 4096 && this.buffer[i] != 0);
        }
        catch (Exception e) {
            try {
                this.procFile.close();
            }
            catch (Exception ignore1) {
                // empty catch block
            }
            e.printStackTrace();
            throw new NoResourceToProbeException(e);
        }
        if (this.nbOfDisks == 0) {
            throw new NoResourceToProbeException();
        }
        this.readsIssued = new long[this.nbOfDisks];
        this.readsMerged = new long[this.nbOfDisks];
        this.readSectors = new long[this.nbOfDisks];
        this.readTimeInMs = new long[this.nbOfDisks];
        this.writesIssued = new long[this.nbOfDisks];
        this.writesMerged = new long[this.nbOfDisks];
        this.writeSectors = new long[this.nbOfDisks];
        this.writeTimeInMs = new long[this.nbOfDisks];
        this.ioInProgress = new long[this.nbOfDisks];
        this.ioInMs = new long[this.nbOfDisks];
        this.averageIoMs = new long[this.nbOfDisks];
        this.resourceNames = new String[this.nbOfDisks * 11];
        this.resourceIds = new int[this.resourceNames.length];
        this.index = new int[this.nbOfDisks];
        for (i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        i = 0;
        int startOfLine = 0;
        while (this.buffer[i] != 10) {
            ++i;
        }
        ++i;
        while (this.buffer[i] != 10) {
            ++i;
        }
        ++i;
        for (int j = 0; j < this.nbOfDisks; ++j) {
            for (int k = 0; k < 3; ++k) {
                while (this.buffer[i] == 32) {
                    ++i;
                }
                while (this.buffer[i] != 32) {
                    ++i;
                }
            }
            while (this.buffer[i] == 32) {
                ++i;
            }
            StringBuffer name = new StringBuffer();
            while (this.buffer[i] != 32) {
                name.append((char)this.buffer[i]);
                ++i;
            }
            this.index[j] = i - startOfLine + 1;
            this.resourceNames[j * 11] = name + " reads issued";
            this.resourceNames[j * 11 + 1] = name + " reads merged";
            this.resourceNames[j * 11 + 2] = name + " read sectors";
            this.resourceNames[j * 11 + 3] = name + " read time in ms";
            this.resourceNames[j * 11 + 4] = name + " writes issued";
            this.resourceNames[j * 11 + 5] = name + " writes merged";
            this.resourceNames[j * 11 + 6] = name + " write sectors";
            this.resourceNames[j * 11 + 7] = name + " write time in ms";
            this.resourceNames[j * 11 + 8] = name + " io in progress";
            this.resourceNames[j * 11 + 9] = name + " io in ms";
            this.resourceNames[j * 11 + 10] = name + " average io in ms";
            while (this.buffer[i] != 10) {
                ++i;
            }
            startOfLine = ++i;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.procFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getDiskUsage();
        long[] result = new long[resourceIds.length];
        block13: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 11 * this.nbOfDisks) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int disk = resourceIds[i] / 11;
            switch (resourceIds[i] % 11) {
                case 0: {
                    result[i] = this.readsIssued[disk];
                    continue block13;
                }
                case 1: {
                    result[i] = this.readsMerged[disk];
                    continue block13;
                }
                case 2: {
                    result[i] = this.readSectors[disk];
                    continue block13;
                }
                case 3: {
                    result[i] = this.readTimeInMs[disk];
                    continue block13;
                }
                case 4: {
                    result[i] = this.writesIssued[disk];
                    continue block13;
                }
                case 5: {
                    result[i] = this.writesMerged[disk];
                    continue block13;
                }
                case 6: {
                    result[i] = this.writeSectors[disk];
                    continue block13;
                }
                case 7: {
                    result[i] = this.writeTimeInMs[disk];
                    continue block13;
                }
                case 8: {
                    result[i] = this.ioInProgress[disk];
                    continue block13;
                }
                case 9: {
                    result[i] = this.ioInMs[disk];
                    continue block13;
                }
                case 10: {
                    result[i] = this.averageIoMs[disk];
                    continue block13;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    private void getDiskUsage() throws ProbeException {
        try {
            this.procFile.seek(0L);
            this.procFile.read(this.buffer);
            int i = 0;
            int currentDisk = 0;
            do {
                i += this.index[currentDisk];
                while (this.buffer[i] == 32) {
                    ++i;
                }
                long foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.readsIssued[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.readsMerged[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.readSectors[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.readTimeInMs[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.writesIssued[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.writesMerged[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.writeSectors[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.writeTimeInMs[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.ioInProgress[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.ioInMs[currentDisk] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.averageIoMs[currentDisk] = foo;
                while (this.buffer[i] != 10 && i < 4096) {
                    ++i;
                }
            } while (++currentDisk < this.nbOfDisks);
        }
        catch (Exception e) {
            throw new ProbeException(e);
        }
    }
}

