/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.linux;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;

public class MemoryProbe
extends AbstractProbe {
    private static final int NB_OF_RESSOURCES = 13;
    private long[] resourceValues;
    private RandomAccessFile meminfoProcFile;
    private RandomAccessFile statProcFile;
    private byte[] buffer;
    private static final int BUFFER_SIZE = 1024;
    private static NoResourceToProbeException invalidMeminfoFileFormat = new NoResourceToProbeException("Invalid /proc/meminfo file format for this probe.");
    private static NoResourceToProbeException invalidStatFileFormat = new NoResourceToProbeException("Invalid /proc/stat file format for this probe.");
    private int startIndex;

    public MemoryProbe() throws NoResourceToProbeException {
        super("memory probe");
        int i;
        this.resourceIds = new int[13];
        this.resourceValues = new long[13];
        for (i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        this.resourceNames = new String[]{"Total memory", "Used memory", "Free memory", "Shared", "Buffers", "Cached", "Total swap", "Used swap", "Free swap", "Pages in", "Pages out", "Swap in", "Swap out"};
        try {
            int j;
            this.meminfoProcFile = new RandomAccessFile("/proc/meminfo", "r");
            this.buffer = new byte[1024];
            this.meminfoProcFile.read(this.buffer);
            i = 0;
            while (this.buffer[i] != 10) {
                ++i;
            }
            this.startIndex = i += 5;
            while (this.buffer[i] == 32) {
                ++i;
            }
            for (j = 0; j < 6; ++j) {
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    ++i;
                }
                if (this.buffer[i] != 32 && this.buffer[i] != 10 && this.buffer[i] != 13) {
                    throw invalidMeminfoFileFormat;
                }
                while (this.buffer[i] == 32) {
                    ++i;
                }
            }
            while (this.buffer[i] != 10) {
                ++i;
            }
            i += 6;
            while (this.buffer[i] == 32) {
                ++i;
            }
            for (j = 0; j < 3; ++j) {
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    ++i;
                }
                if (this.buffer[i] != 32 && this.buffer[i] != 10 && this.buffer[i] != 13) {
                    throw invalidMeminfoFileFormat;
                }
                while (this.buffer[i] == 32) {
                    ++i;
                }
            }
        }
        catch (Exception e) {
            try {
                this.meminfoProcFile.close();
            }
            catch (Exception ignore1) {
                // empty catch block
            }
            e.printStackTrace();
            throw new NoResourceToProbeException(e);
        }
        try {
            this.statProcFile = new RandomAccessFile("/proc/stat", "r");
            this.buffer = new byte[1024];
            this.statProcFile.read(this.buffer);
            i = 0;
            while (true) {
                if (this.buffer[i] != 10) {
                    ++i;
                    continue;
                }
                if (this.buffer[++i] == 112) break;
            }
            int n = ++i;
            ++i;
            if (this.buffer[n] != 97) {
                throw invalidStatFileFormat;
            }
            if (this.buffer[i++] != 103) {
                throw invalidStatFileFormat;
            }
            if (this.buffer[i++] != 101) {
                throw invalidStatFileFormat;
            }
            while (this.buffer[i] == 32) {
                ++i;
            }
            for (int pageStat = 0; pageStat < 2; ++pageStat) {
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    ++i;
                }
                if (this.buffer[i] != 32 && this.buffer[i] != 10 && this.buffer[i] != 13) {
                    throw invalidStatFileFormat;
                }
                while (this.buffer[i] == 32) {
                    ++i;
                }
            }
            while (this.buffer[i] != 10) {
                ++i;
            }
            int n2 = ++i;
            ++i;
            if (this.buffer[n2] != 115) {
                throw invalidStatFileFormat;
            }
            if (this.buffer[i++] != 119) {
                throw invalidStatFileFormat;
            }
            if (this.buffer[i++] != 97) {
                throw invalidStatFileFormat;
            }
            if (this.buffer[i++] != 112) {
                throw invalidStatFileFormat;
            }
            while (this.buffer[i] == 32) {
                ++i;
            }
            for (int swapStat = 0; swapStat < 2; ++swapStat) {
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    ++i;
                }
                if (this.buffer[i] != 32 && this.buffer[i] != 10 && this.buffer[i] != 13) {
                    throw invalidStatFileFormat;
                }
                while (this.buffer[i] == 32) {
                    ++i;
                }
            }
        }
        catch (Exception e) {
            try {
                this.statProcFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
            throw new NoResourceToProbeException(e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.meminfoProcFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getMemoryUsage();
        long[] result = new long[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 13) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            result[i] = this.resourceValues[resourceIds[i]];
        }
        return result;
    }

    private void getMemoryUsage() throws ProbeException {
        long foo;
        int i;
        try {
            int j;
            this.meminfoProcFile.seek(0L);
            this.meminfoProcFile.read(this.buffer);
            i = this.startIndex;
            while (this.buffer[i] == 32) {
                ++i;
            }
            for (j = 0; j < 6; ++j) {
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.resourceValues[j] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
            }
            while (this.buffer[i] != 10) {
                ++i;
            }
            i += 6;
            while (this.buffer[i] == 32) {
                ++i;
            }
            for (j = 6; j < 9; ++j) {
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.resourceValues[j] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new ProbeException(e);
        }
        try {
            this.statProcFile.seek(0L);
            this.statProcFile.read(this.buffer);
            i = 4;
            while (true) {
                if (this.buffer[i] != 10) {
                    ++i;
                    continue;
                }
                if (this.buffer[++i] == 112) break;
            }
            i += 4;
            while (this.buffer[i] == 32) {
                ++i;
            }
            foo = 0L;
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                foo = foo * 10L + (long)this.buffer[i] - 48L;
                ++i;
            }
            this.resourceValues[9] = foo;
            while (this.buffer[i] == 32) {
                ++i;
            }
            foo = 0L;
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                foo = foo * 10L + (long)this.buffer[i] - 48L;
                ++i;
            }
            this.resourceValues[10] = foo;
            while (this.buffer[i] != 10) {
                ++i;
            }
            i += 5;
            while (this.buffer[i] == 32) {
                ++i;
            }
            foo = 0L;
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                foo = foo * 10L + (long)this.buffer[i] - 48L;
                ++i;
            }
            this.resourceValues[11] = foo;
            while (this.buffer[i] == 32) {
                ++i;
            }
            foo = 0L;
            while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                foo = foo * 10L + (long)this.buffer[i] - 48L;
                ++i;
            }
            this.resourceValues[12] = foo;
        }
        catch (Exception e) {
            throw new ProbeException(e);
        }
    }
}

