/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.windows;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class BatteryProbe
extends AbstractProbe
implements Probe {
    private int nbOfBatteries = 1;
    private long[] ACLineStatus = new long[this.nbOfBatteries];
    private long[] batFlags = new long[this.nbOfBatteries];
    private long[] batLifePercent = new long[this.nbOfBatteries];
    private long[] batLifeTime = new long[this.nbOfBatteries];
    private long[] batFullLifeTime = new long[this.nbOfBatteries];

    public BatteryProbe() throws NoResourceToProbeException {
        super("battery probe");
        int i;
        this.resourceNames = new String[5 * this.nbOfBatteries];
        for (i = 0; i < this.nbOfBatteries; ++i) {
            this.resourceNames[i * 5] = "AC Line Status";
            this.resourceNames[i * 5 + 1] = "Battery Flags";
            this.resourceNames[i * 5 + 2] = "Battery life percentage";
            this.resourceNames[i * 5 + 3] = "Battery remaining life time";
            this.resourceNames[i * 5 + 4] = "Battery full life time";
        }
        this.resourceIds = new int[this.resourceNames.length];
        for (i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        long[] values = new long[5];
        for (int i = 0; i < this.nbOfBatteries; ++i) {
            values = this.getBatteryStatus("0");
            this.ACLineStatus[i] = values[0];
            this.batFlags[i] = values[1];
            this.batLifePercent[i] = values[2];
            this.batLifeTime[i] = values[3];
            this.batFullLifeTime[i] = values[4];
        }
        long[] result = new long[resourceIds.length];
        block8: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= this.resourceNames.length) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int res = resourceIds[i] / 5;
            switch (resourceIds[i] % 5) {
                case 0: {
                    result[i] = this.ACLineStatus[res];
                    continue block8;
                }
                case 1: {
                    result[i] = this.batFlags[res];
                    continue block8;
                }
                case 2: {
                    result[i] = this.batLifePercent[res];
                    continue block8;
                }
                case 3: {
                    result[i] = this.batLifeTime[res];
                    continue block8;
                }
                case 4: {
                    result[i] = this.batFullLifeTime[res];
                    continue block8;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    public native long[] getBatteryStatus(String var1);

    static {
        System.loadLibrary("LeWYS");
    }
}

