/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.pump;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.multiplexer.PeriodicAttachment;
import org.objectweb.dream.multiplexer.PullPushMultiplexer;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.manager.ProbeManager;
import org.objectweb.lewys.pump.MonitoringLease;
import org.objectweb.lewys.pump.MonitoringPumpManager;
import org.objectweb.lewys.pump.OutputManager;
import org.objectweb.util.monolog.api.BasicLevel;

public class MonitoringPumpManagerImpl
extends AbstractComponent
implements MonitoringPumpManager {
    private ArrayList leases = new ArrayList();
    private PullPushMultiplexer monitoringPumpThread;
    private ProbeManager probeManager;
    private OutputManager outputManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitoringLease subscribe(String[] probeNames, int[][] resourceIds, String[] outputNames, long startingDate, long samplingFrequencyInMillis, long endDate, boolean aggregate, boolean clone) throws ProbeException {
        try {
            String[] threadInputNames = new String[probeNames.length];
            for (int i = 0; i < probeNames.length; ++i) {
                threadInputNames[i] = this.probeManager.getOrRegister(probeNames[i]);
            }
            String[] threadOutputNames = new String[outputNames.length];
            for (int i = 0; i < outputNames.length; ++i) {
                threadOutputNames[i] = this.outputManager.get(outputNames[i]);
            }
            Map[] inputContexts = new Map[probeNames.length];
            for (int i = 0; i < probeNames.length; ++i) {
                inputContexts[i] = new HashMap();
                inputContexts[i].put("resourceIds", resourceIds[i]);
            }
            Map[] outputContexts = new Map[outputNames.length];
            for (int i = 0; i < outputNames.length; ++i) {
                outputContexts[i] = null;
            }
            HashMap<String, Long> attachmentParameters = new HashMap<String, Long>();
            attachmentParameters.put("startingDate", new Long(startingDate));
            attachmentParameters.put("pullingFrequency", new Long(samplingFrequencyInMillis));
            attachmentParameters.put("endDate", new Long(endDate));
            PeriodicAttachment attachment = (PeriodicAttachment)this.monitoringPumpThread.attach(threadInputNames, inputContexts, threadOutputNames, outputContexts, attachmentParameters);
            MonitoringLease lease = new MonitoringLease(attachment.getId(), probeNames, resourceIds, outputNames, startingDate, samplingFrequencyInMillis, endDate, aggregate, clone);
            ArrayList arrayList = this.leases;
            synchronized (arrayList) {
                this.leases.add(lease);
            }
            return (MonitoringLease)lease.clone();
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.ERROR, (Object)("Unable to subscribe to probes " + probeNames), (Throwable)e);
            throw new ProbeException("Unable to subscribe to probes " + probeNames, e);
        }
    }

    public boolean unsubscribe(MonitoringLease lease) {
        return false;
    }

    public void update(MonitoringLease lease) {
    }

    public ArrayList getMonitoringLeases() {
        ArrayList<Object> returnedLeases = new ArrayList<Object>();
        Iterator iter = this.leases.iterator();
        while (iter.hasNext()) {
            returnedLeases.add(((MonitoringLease)iter.next()).clone());
        }
        return returnedLeases;
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("monitoring-pump-thread")) {
            this.monitoringPumpThread = (PullPushMultiplexer)serverItf;
        } else if (clientItfName.equals("probe-manager")) {
            this.probeManager = (ProbeManager)serverItf;
        } else if (clientItfName.equals("output-manager")) {
            this.outputManager = (OutputManager)serverItf;
        }
    }

    public String[] listFc() {
        return new String[]{"monitoring-pump-thread", "probe-manager", "output-manager"};
    }
}

