/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.repository.requestplayer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.objectweb.cjdbc.common.util.Stats;
import org.objectweb.lewys.repository.requestplayer.ClientEmulator;

public class ClientThread
extends Thread {
    protected static final boolean DEBUG = false;
    protected Stats selectStats = null;
    protected Stats unknownStats = null;
    protected Stats updateStats = null;
    protected Stats insertStats = null;
    protected Stats deleteStats = null;
    protected Stats beginStats = null;
    protected Stats commitStats = null;
    protected Stats rollbackStats = null;
    protected Stats getConnectionStats = null;
    protected Stats closeStats = null;
    protected Stats getRequestStats = null;
    protected int updateType;
    protected long timeInMS;
    private boolean killed = false;
    protected Connection conn = null;
    protected ClientEmulator father;
    protected int threadId;
    protected int connectionType;
    protected int tableID;
    protected ArrayList batch;
    protected int batchSize;

    public ClientThread(int threadId, ClientEmulator father, int connectionType, int updateType, long timeInMS, int tableID, int batchSize) {
        super("ClientThread" + threadId);
        this.selectStats = father.getSelectStats();
        this.unknownStats = father.getUnknownStats();
        this.updateStats = father.getUpdateStats();
        this.insertStats = father.getInsertStats();
        this.deleteStats = father.getDeleteStats();
        this.beginStats = father.getBeginStats();
        this.commitStats = father.getCommitStats();
        this.rollbackStats = father.getRollbackStats();
        this.getRequestStats = father.getGetRequestStats();
        this.getConnectionStats = father.getGetConnectionStats();
        this.closeStats = father.getCloseStats();
        this.father = father;
        this.threadId = threadId;
        this.connectionType = connectionType;
        this.updateType = updateType;
        this.timeInMS = timeInMS;
        this.tableID = tableID;
        this.batchSize = batchSize;
        this.batch = new ArrayList(batchSize);
        if (this.connectionType == 1) {
            this.conn = father.getConnection();
        }
    }

    public void run() {
        String request = null;
        int tid = 0;
        block13: while (true) {
            long startg = System.currentTimeMillis();
            request = this.father.parallelGetNextSQLRequest(tid);
            long endg = System.currentTimeMillis();
            this.getRequestStats.incrementCount();
            this.getRequestStats.updateTime(endg - startg);
            if (request == null) {
                if (tid != 0) {
                    System.out.println(this.threadId + ": Warning! Rollbacking unterminated transaction " + tid);
                    request = "R";
                } else {
                    try {
                        ClientThread.sleep(this.timeInMS);
                    }
                    catch (InterruptedException e) {
                        if (!this.killed) {
                            System.out.println(this.threadId + ": Clinet thread interrupted");
                        }
                        return;
                    }
                }
            }
            request = request.replaceFirst("measurements ", "measurements" + this.tableID + " ");
            try {
                switch (request.charAt(0)) {
                    case 'B': {
                        long startb = System.currentTimeMillis();
                        if (this.connectionType != 1) {
                            this.conn = this.getConnection();
                        }
                        this.conn.setAutoCommit(false);
                        long endb = System.currentTimeMillis();
                        this.beginStats.incrementCount();
                        this.beginStats.updateTime(endb - startb);
                        tid = new Integer(request.substring(2));
                        break;
                    }
                    case 'C': {
                        long startc = System.currentTimeMillis();
                        this.conn.commit();
                        long endc = System.currentTimeMillis();
                        this.commitStats.incrementCount();
                        this.commitStats.updateTime(endc - startc);
                        tid = 0;
                        if (this.connectionType == 1) continue block13;
                        this.closeConnection();
                        break;
                    }
                    case 'R': {
                        long startr = System.currentTimeMillis();
                        this.conn.rollback();
                        long endr = System.currentTimeMillis();
                        this.rollbackStats.incrementCount();
                        this.rollbackStats.updateTime(endr - startr);
                        tid = 0;
                        if (this.connectionType == 1) continue block13;
                        this.closeConnection();
                        break;
                    }
                    case 'S': {
                        if (tid == 0 && this.connectionType != 1) {
                            this.conn = this.getConnection();
                            this.execReadRequest(request);
                            this.closeConnection();
                            break;
                        }
                        this.execReadRequest(request);
                        break;
                    }
                    case 'W': {
                        if (tid == 0 && this.connectionType != 1) {
                            this.conn = this.getConnection();
                            if (this.updateType != 4) {
                                this.execWriteRequest(request);
                            } else {
                                this.execBulkWriteRequest(request);
                            }
                            this.closeConnection();
                            break;
                        }
                        if (this.updateType != 4) {
                            this.execWriteRequest(request);
                            break;
                        }
                        this.execBulkWriteRequest(request);
                        break;
                    }
                    default: {
                        System.err.println(this.threadId + ": Error! Unsupported request " + request);
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                System.err.println(this.threadId + ": An error occured while executing SQL request (" + e.getMessage() + ")");
                if (request.charAt(0) != 'S' && request.charAt(0) != 'W' && tid != 0) {
                    try {
                        this.conn.rollback();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    this.father.ignoreTid(tid);
                    tid = 0;
                }
                if (this.connectionType == 1) continue;
                this.closeConnection();
                continue;
            }
            break;
        }
    }

    private void execWriteRequest(String req) {
        Statement stmt = null;
        String request = req.substring(2).toLowerCase();
        long startw = System.currentTimeMillis();
        try {
            stmt = this.conn.createStatement();
            stmt.setQueryTimeout(this.father.getTimeout());
            stmt.executeUpdate(request);
            stmt.close();
        }
        catch (SQLException e) {
            if (request.startsWith("insert")) {
                this.insertStats.incrementError();
            } else if (request.startsWith("update")) {
                this.updateStats.incrementError();
            } else if (request.startsWith("delete")) {
                this.deleteStats.incrementError();
            } else {
                this.unknownStats.incrementError();
            }
            System.err.println(this.threadId + ": Failed to execute request: " + request + "(" + e + ")");
            return;
        }
        long endw = System.currentTimeMillis();
        if (request.startsWith("insert")) {
            this.insertStats.incrementCount();
            this.insertStats.updateTime(endw - startw);
        } else if (request.startsWith("update")) {
            this.updateStats.incrementCount();
            this.updateStats.updateTime(endw - startw);
        } else if (request.startsWith("delete")) {
            this.deleteStats.incrementCount();
            this.deleteStats.updateTime(endw - startw);
        } else {
            this.unknownStats.incrementCount();
            this.unknownStats.updateTime(endw - startw);
        }
    }

    private void execBulkWriteRequest(String req) {
        Statement stmt = null;
        String request = req.substring(2).toLowerCase();
        this.batch.add(request);
        if (this.batch.size() < this.batchSize) {
            return;
        }
        long startw = System.currentTimeMillis();
        try {
            this.conn.setAutoCommit(false);
            stmt = this.conn.createStatement();
            stmt.setQueryTimeout(this.father.getTimeout());
            for (int i = 0; i < this.batchSize; ++i) {
                stmt.addBatch((String)this.batch.get(i));
            }
            stmt.executeBatch();
            stmt.close();
            this.conn.commit();
        }
        catch (SQLException e) {
            try {
                this.conn.rollback();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            for (int i = 0; i < this.batch.size(); ++i) {
                request = (String)this.batch.remove(i);
                --i;
                if (request.startsWith("insert")) {
                    this.insertStats.incrementError();
                } else if (request.startsWith("update")) {
                    this.updateStats.incrementError();
                } else if (request.startsWith("delete")) {
                    this.deleteStats.incrementError();
                } else {
                    this.unknownStats.incrementError();
                }
                System.err.println(this.threadId + ": Failed to execute request: " + request + "(" + e + ")");
            }
            return;
        }
        long endw = System.currentTimeMillis();
        for (int i = 0; i < this.batch.size(); ++i) {
            request = (String)this.batch.remove(i);
            --i;
            if (request.startsWith("insert")) {
                this.insertStats.incrementCount();
                this.insertStats.updateTime((endw - startw) / (long)this.batchSize);
                continue;
            }
            if (request.startsWith("update")) {
                this.updateStats.incrementCount();
                this.updateStats.updateTime((endw - startw) / (long)this.batchSize);
                continue;
            }
            if (request.startsWith("delete")) {
                this.deleteStats.incrementCount();
                this.deleteStats.updateTime((endw - startw) / (long)this.batchSize);
                continue;
            }
            this.unknownStats.incrementCount();
            this.unknownStats.updateTime((endw - startw) / (long)this.batchSize);
        }
    }

    private void execReadRequest(String req) {
        Statement stmt = null;
        ResultSet dbReply = null;
        String request = req.substring(2);
        long startr = System.currentTimeMillis();
        try {
            stmt = this.conn.createStatement();
            stmt.setQueryTimeout(this.father.getTimeout());
            dbReply = stmt.executeQuery(request);
            if (dbReply != null) {
                dbReply.next();
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.selectStats.incrementError();
            System.err.println(this.threadId + ": Failed to execute request: " + request + "(" + e + ")");
        }
        long endr = System.currentTimeMillis();
        this.selectStats.incrementCount();
        this.selectStats.updateTime(endr - startr);
    }

    private void closeConnection() {
        long start = System.currentTimeMillis();
        if (this.connectionType == 0) {
            this.father.closeConnection(this.conn);
        } else if (this.connectionType == 2) {
            this.father.releaseConnectionToPool(this.conn);
        }
        long end = System.currentTimeMillis();
        this.closeStats.incrementCount();
        this.closeStats.updateTime(end - start);
    }

    private Connection getConnection() {
        Connection c = null;
        long start = System.currentTimeMillis();
        if (this.connectionType == 0) {
            c = this.father.getConnection();
        } else if (this.connectionType == 2) {
            c = this.father.getConnectionFromPool();
        }
        long end = System.currentTimeMillis();
        this.getConnectionStats.incrementCount();
        this.getConnectionStats.updateTime(end - start);
        return c;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public void setKilled(boolean killed) {
        this.killed = killed;
    }
}

