/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.objectweb.util.monolog.wrapper.common.AbstractFactory;
import org.objectweb.util.monolog.wrapper.log4j.ConsoleHandler;
import org.objectweb.util.monolog.wrapper.log4j.FileHandler;
import org.objectweb.util.monolog.wrapper.log4j.GenericHandler;
import org.objectweb.util.monolog.wrapper.log4j.LevelImpl;
import org.objectweb.util.monolog.wrapper.log4j.MonologCategory;
import org.objectweb.util.monolog.wrapper.log4j.MonologCategoryFactory;
import org.objectweb.util.monolog.wrapper.log4j.RollingFileHandler;

public class MonologLoggerFactory
extends AbstractFactory {
    public static final String LOG4J_CF_PROP = "log4j.categoryFactory";
    public static final String LOG4J_CF_VALUE = "org.objectweb.util.monolog.wrapper.log4j.MonologCategoryFactory";
    protected Logger rootLogger = new MonologCategory(org.apache.log4j.Logger.getRootLogger());
    private static LoggerFactory factory;

    public void configure(Properties prop) throws Exception {
        MonologLoggerFactory.debug("MonologLoggerFactory.configure(prop=" + prop + ")");
        if (prop == null) {
            if (!org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
                BasicConfigurator.configure();
            }
            return;
        }
        String conf = prop.getProperty("log.config.type", prop.getProperty("log4jConfiguration", "default"));
        MonologLoggerFactory.debug("MonologLoggerFactory.configure(): conf=" + conf);
        if ("default".equals(conf)) {
            if (!org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
                BasicConfigurator.configure();
            }
            return;
        }
        String filename = prop.getProperty("log.config.file", prop.getProperty("log4jConfigurationFile", ""));
        MonologLoggerFactory.debug("MonologLoggerFactory.configure(): filename=" + filename);
        if ("xml".equals(conf)) {
            DOMConfigurator.configure((String)filename);
        } else if ("property".equals(conf)) {
            Properties log4jfileprop = null;
            if (prop.getProperty("log.config.file.useclasspath", "false").equalsIgnoreCase("true") || prop.getProperty("findFileInClassPath", "false").equalsIgnoreCase("true")) {
                MonologLoggerFactory.debug("MonologLoggerFactory.configure(): load from classpath");
                if (!"log4j.properties".equals(filename)) {
                    MonologLoggerFactory.debug("MonologLoggerFactory.configure(): not default config file");
                    log4jfileprop = this.getProperties(filename);
                    log4jfileprop.setProperty(LOG4J_CF_PROP, LOG4J_CF_VALUE);
                    PropertyConfigurator.configure((Properties)log4jfileprop);
                }
            } else {
                MonologLoggerFactory.debug("MonologLoggerFactory.configure(): load from file system");
                log4jfileprop = new Properties();
                log4jfileprop.load(new FileInputStream(filename));
                log4jfileprop.setProperty(LOG4J_CF_PROP, LOG4J_CF_VALUE);
                PropertyConfigurator.configure((Properties)log4jfileprop);
            }
        } else {
            throw new Exception("Unsupported configuration type: " + conf);
        }
        MonologLoggerFactory.debug("MonologLoggerFactory.configure(): End");
    }

    private Properties getProperties(String name) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
        if (is != null) {
            Properties props = new Properties();
            props.load(is);
            return props;
        }
        throw new FileNotFoundException("Not found in classpath: " + name);
    }

    public Logger getLogger(String key) {
        if (key == null || key.length() == 0 || key.equalsIgnoreCase("root")) {
            return this.rootLogger;
        }
        if (this.resourceBundleName == null) {
            return (Logger)org.apache.log4j.Logger.getLogger((String)key, (LoggerFactory)factory);
        }
        return this.getLogger(key, this.resourceBundleName);
    }

    public synchronized Logger getLogger(String key, String rbn) {
        if (key == null || key.length() == 0 || key.equalsIgnoreCase("root")) {
            return this.rootLogger;
        }
        org.apache.log4j.Logger res = org.apache.log4j.Logger.getLogger((String)key, (LoggerFactory)factory);
        res.setResourceBundle(ResourceBundle.getBundle(rbn));
        return (Logger)res;
    }

    public Logger[] getLoggers() {
        HashSet al = new HashSet();
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof Logger)) continue;
            al.add(o);
        }
        al.add(this.rootLogger);
        return al.toArray(new TopicalLogger[0]);
    }

    public Handler createHandler(String hn, byte handlertype) {
        Handler res = (Handler)this.handlers.get(hn);
        if (res != null) {
            return res;
        }
        switch (handlertype) {
            case 2: {
                res = new ConsoleHandler(hn);
                break;
            }
            case 1: {
                res = new FileHandler(hn);
                break;
            }
            case 3: {
                res = new RollingFileHandler(hn);
                break;
            }
            case 4: {
                res = new GenericHandler(hn);
                break;
            }
            default: {
                return null;
            }
        }
        this.handlers.put(hn, res);
        return res;
    }

    static {
        BasicLevel.INHERIT = -1;
        MonologLoggerFactory.debug("INHERIT= " + BasicLevel.INHERIT);
        BasicLevel.DEBUG = Level.DEBUG.toInt();
        MonologLoggerFactory.debug("DEBUG= " + BasicLevel.DEBUG);
        BasicLevel.INFO = Level.INFO.toInt();
        MonologLoggerFactory.debug("INFO= " + BasicLevel.INFO);
        BasicLevel.WARN = Level.WARN.toInt();
        MonologLoggerFactory.debug("WARN= " + BasicLevel.WARN);
        BasicLevel.ERROR = Level.ERROR.toInt();
        MonologLoggerFactory.debug("ERROR= " + BasicLevel.ERROR);
        BasicLevel.FATAL = Level.FATAL.toInt();
        MonologLoggerFactory.debug("FATAL= " + BasicLevel.FATAL);
        BasicLevel.LEVEL_INHERIT = new LevelImpl("INHERIT", BasicLevel.INHERIT);
        BasicLevel.LEVEL_DEBUG = new LevelImpl("DEBUG", BasicLevel.DEBUG);
        BasicLevel.LEVEL_INFO = new LevelImpl("INFO", BasicLevel.INFO);
        BasicLevel.LEVEL_WARN = new LevelImpl("WARN", BasicLevel.WARN);
        BasicLevel.LEVEL_ERROR = new LevelImpl("ERROR", BasicLevel.ERROR);
        BasicLevel.LEVEL_FATAL = new LevelImpl("FATAL", BasicLevel.FATAL);
        if (!org.apache.log4j.Logger.getRoot().getAllAppenders().hasMoreElements()) {
            BasicConfigurator.configure();
        }
        factory = new MonologCategoryFactory();
    }
}

