/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.adl.type;

import org.objectweb.dream.adl.AbstractDelagatingChecker;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterface;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;

public class FractalTypeChecker
extends AbstractDelagatingChecker {
    protected void doChek(Object legacy, Object node) throws ADLException {
        ComponentType legacyType = (ComponentType)((Component)legacy).getFcType();
        if (node instanceof InterfaceContainer) {
            Interface[] itfs = ((InterfaceContainer)node).getInterfaces();
            for (int i = 0; i < itfs.length; ++i) {
                TypeInterface itfType = (TypeInterface)itfs[i];
                InterfaceType legacyItfType = this.getLegacyInterfaceType(legacyType, itfType);
                if (legacyItfType.isFcClientItf() != "client".equals(itfType.getRole())) {
                    throw new ADLException("Legacy interface and node interface has not the same role", (Node)((Object)itfType));
                }
                if (legacyItfType.isFcCollectionItf() == "collection".equals(itfType.getCardinality())) continue;
                throw new ADLException("Legacy interface and node interface has not the same cardinality", (Node)((Object)itfType));
            }
        }
    }

    InterfaceType getLegacyInterfaceType(ComponentType legacyType, TypeInterface adlType) throws ADLException {
        boolean collection = "collection".equals(adlType.getCardinality());
        InterfaceType[] interfaceTypes = legacyType.getFcInterfaceTypes();
        if (collection) {
            for (int i = 0; i < interfaceTypes.length; ++i) {
                InterfaceType itfType = interfaceTypes[i];
                if (!adlType.getName().startsWith(itfType.getFcItfName())) continue;
                return itfType;
            }
        } else {
            for (int i = 0; i < interfaceTypes.length; ++i) {
                InterfaceType itfType = interfaceTypes[i];
                if (!adlType.getName().equals(itfType.getFcItfName())) continue;
                return itfType;
            }
        }
        throw new ADLException("The legacy component has not the specified interface", (Node)((Object)adlType));
    }
}

