/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.cache;

import java.util.Map;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.Pull;
import org.objectweb.dream.PullException;
import org.objectweb.dream.cache.CacheAttributeController;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.message.manager.MessageManager;
import org.objectweb.dream.time.GetTimeStamp;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;

public class BasicCacheImpl
extends AbstractComponent
implements Pull,
CacheAttributeController {
    protected long timeOut = 0L;
    protected MessageManager messageManagerItf;
    protected GetTimeStamp getTimeStamp;
    protected Pull inPull;
    protected Message cachedMessage;
    protected long lastTimeStamp;

    public Message pull(Map context) throws PullException {
        long currentTimeStamp = this.getTimeStamp.getTimeStamp();
        if (currentTimeStamp - this.lastTimeStamp > this.timeOut) {
            this.lastTimeStamp = currentTimeStamp;
            this.messageManagerItf.deleteMessage(this.cachedMessage);
            this.cachedMessage = this.inPull.pull(context);
        }
        return this.messageManagerItf.duplicateMessage(this.cachedMessage, true);
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("in-pull")) {
            this.inPull = (Pull)serverItf;
        } else if (clientItfName.equals("get-time-stamp")) {
            this.getTimeStamp = (GetTimeStamp)serverItf;
        } else if (clientItfName.equals("message-manager")) {
            this.messageManagerItf = (MessageManager)serverItf;
        }
    }

    public String[] listFc() {
        return new String[]{"in-pull", "message-manager", "get-time-stamp"};
    }
}

