/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.channel;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Map;
import org.objectweb.dream.PushException;
import org.objectweb.dream.channel.AbstractTCPChannelOutImpl;
import org.objectweb.dream.channel.IPChannelDestinationChunk;
import org.objectweb.dream.channel.MultiDestinationChannelOutAttributeController;
import org.objectweb.dream.message.ExtensibleMessage;
import org.objectweb.dream.message.Message;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicTCPChannelOutImpl
extends AbstractTCPChannelOutImpl
implements MultiDestinationChannelOutAttributeController {
    protected String chunkName = "IPChannelDestination";

    public void push(Message message, Map context) throws PushException {
        IPChannelDestinationChunk destination = (IPChannelDestinationChunk)message.getChunk(this.chunkName);
        if (message instanceof ExtensibleMessage) {
            this.messageManagerItf.deleteChunk(((ExtensibleMessage)message).removeChunk(this.chunkName));
        }
        try {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("try to send message -> " + message));
            }
            Socket sock = this.connectSocket(destination.getChannelDestinationAddr(), destination.getChannelDestinationPort());
            ObjectOutputStream oos = new ObjectOutputStream(sock.getOutputStream());
            this.logger.log(BasicLevel.DEBUG, (Object)"write message");
            this.messageCodecItf.encode(oos, message);
            this.receiveAck(sock);
            this.messageManagerItf.deleteMessage(message);
            oos.close();
            sock.close();
        }
        catch (IOException e) {
            throw new PushException(e);
        }
    }

    public String getDestinationChunkName() {
        return this.chunkName;
    }

    public void setDestinationChunkName(String name) {
        this.chunkName = name;
    }

    protected void receiveAck(Socket sock) throws IOException {
    }
}

