/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.message;

import java.io.Serializable;
import org.objectweb.dream.message.ChunkType;

public class BasicChunkType
implements ChunkType,
Serializable {
    private Class chunkItf;
    private Class chunkImpl;

    public BasicChunkType(String itfSignature, String implSignature) throws ClassNotFoundException {
        this(Class.forName(itfSignature), Class.forName(implSignature));
    }

    public BasicChunkType(Class chunkItf, Class chunkImpl) {
        if (!chunkItf.isInterface()) {
            throw new IllegalArgumentException(chunkItf.getName() + " is not an Interface");
        }
        if (!chunkItf.isAssignableFrom(chunkImpl)) {
            throw new IllegalArgumentException(chunkImpl.getName() + "is not a sub class of the given interface");
        }
        this.chunkItf = chunkItf;
        this.chunkImpl = chunkImpl;
    }

    public String getChunkSignature() {
        return this.chunkItf.getName();
    }

    public Class getChunkItf() {
        return this.chunkItf;
    }

    public Class getChunkImpl() {
        return this.chunkImpl;
    }

    public boolean isSubTypeOf(ChunkType t) {
        if (t instanceof BasicChunkType) {
            return ((BasicChunkType)t).getChunkItf().isAssignableFrom(this.chunkItf);
        }
        try {
            Class<?> tChunkItf = Class.forName(t.getChunkSignature());
            return tChunkItf.isAssignableFrom(this.chunkItf);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

