/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.protocol.causality;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Update
implements Externalizable {
    private transient short l;
    private transient short c;
    private transient int stamp;
    private transient Update next;
    private static Update[] pool = new Update[30];
    private static int elementCount;

    public Update() {
    }

    public Update(short l, short c, int stamp) {
        this.l = l;
        this.c = c;
        this.stamp = stamp;
    }

    public Update(short l, short c, int s, Update list) {
        this.l = l;
        this.c = c;
        this.stamp = s;
        if (list != null) {
            this.next = list.next;
            list.next = this;
        } else {
            this.next = null;
        }
    }

    public short getLine() {
        return this.l;
    }

    public short getColumn() {
        return this.c;
    }

    public int getStamp() {
        return this.stamp;
    }

    public Update getNext() {
        return this.next;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Update u = this;
        while (u != null) {
            u.toStringBuffer(sb);
            u = u.next;
        }
        sb.append(')');
        return sb.toString();
    }

    private StringBuffer toStringBuffer(StringBuffer sb) {
        sb.append('(');
        sb.append(this.l).append(", ");
        sb.append(this.c).append(", ");
        sb.append(this.stamp).append(')');
        return sb;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short l;
        this.l = in.readShort();
        this.c = in.readShort();
        this.stamp = in.readInt();
        while ((l = in.readShort()) != -1) {
            Update.alloc(l, in.readShort(), in.readInt(), this);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Update update = this;
        while (update != null) {
            out.writeShort(update.l);
            out.writeShort(update.c);
            out.writeInt(update.stamp);
            Update nextUpdate = update.next;
            Update.unalloc(update);
            update = nextUpdate;
        }
        out.writeShort(-1);
    }

    public static Update readUpdate(ObjectInput in) throws IOException, ClassNotFoundException {
        Update u = Update.alloc((short)0, (short)0, 0, null);
        u.readExternal(in);
        return u;
    }

    static synchronized Update alloc(short l, short c, int s, Update list) {
        if (elementCount == 0) {
            return new Update(l, c, s, list);
        }
        Update update = pool[--elementCount];
        update.l = l;
        update.c = c;
        update.stamp = s;
        if (list != null) {
            update.next = list.next;
            list.next = update;
        } else {
            update.next = null;
        }
        Update.pool[Update.elementCount] = null;
        return update;
    }

    static synchronized void unalloc(Update update) {
        if (elementCount == pool.length) {
            return;
        }
        Update.pool[Update.elementCount] = update;
        update.next = null;
        ++elementCount;
    }
}

