/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.dream.pump;

import java.util.Collections;
import org.objectweb.dream.AbstractComponent;
import org.objectweb.dream.InitializationException;
import org.objectweb.dream.Pull;
import org.objectweb.dream.PullException;
import org.objectweb.dream.Push;
import org.objectweb.dream.PushException;
import org.objectweb.dream.control.activity.Util;
import org.objectweb.dream.control.activity.task.AbstractTask;
import org.objectweb.dream.control.activity.task.Task;
import org.objectweb.dream.message.Message;
import org.objectweb.dream.pump.PumpAttributeController;
import org.objectweb.dream.synchro.Mutex;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;

public class SynchronizedPumpImpl
extends AbstractComponent
implements PumpAttributeController {
    protected Push outPushItf;
    protected Pull inPullItf;
    protected Mutex mutexItf;
    protected Task pumpTask = new PumpTask();
    protected boolean pushNullPolicy = false;

    protected void initComponent(Component componentItf) throws InitializationException {
        super.initComponent(componentItf);
        try {
            Util.addTask(componentItf, this.pumpTask, Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            throw new InitializationException(e, componentItf, "Can't add task");
        }
    }

    public String[] listFc() {
        return new String[]{"out-push", "in-pull", "mutex"};
    }

    public synchronized void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        super.bindFc(clientItfName, serverItf);
        if (clientItfName.equals("out-push")) {
            this.outPushItf = (Push)serverItf;
        } else if (clientItfName.equals("in-pull")) {
            this.inPullItf = (Pull)serverItf;
        } else if (clientItfName.equals("mutex")) {
            this.mutexItf = (Mutex)serverItf;
        }
    }

    public boolean getPushNullPolicy() {
        return this.pushNullPolicy;
    }

    public void setPushNullPolicy(boolean pushNull) {
        this.pushNullPolicy = pushNull;
    }

    class PumpTask
    extends AbstractTask {
        public PumpTask() {
            super("PumpTask");
        }

        public Object execute(Object hints) throws InterruptedException {
            if (SynchronizedPumpImpl.this.mutexItf != null) {
                SynchronizedPumpImpl.this.mutexItf.lock();
            }
            try {
                block8: {
                    try {
                        Message msg = SynchronizedPumpImpl.this.inPullItf.pull(null);
                        if (msg == null && !SynchronizedPumpImpl.this.pushNullPolicy) break block8;
                        SynchronizedPumpImpl.this.outPushItf.push(msg, null);
                    }
                    catch (PullException e) {
                        throw new InterruptedException(e.getLocalizedMessage());
                    }
                    catch (PushException e) {
                        throw new InterruptedException(e.getLocalizedMessage());
                    }
                }
                Object var4_5 = null;
                if (SynchronizedPumpImpl.this.mutexItf != null) {
                    SynchronizedPumpImpl.this.mutexItf.unlock();
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (SynchronizedPumpImpl.this.mutexItf != null) {
                    SynchronizedPumpImpl.this.mutexItf.unlock();
                }
                throw throwable;
            }
            return EXECUTE_AGAIN;
        }
    }
}

