/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.NodeClassLoader;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.ComponentDefinition;
import org.objectweb.fractal.adl.components.ComponentLoaderAttributes;
import org.objectweb.fractal.adl.util.ClassLoaderHelper;

public class ComponentLoader
extends AbstractLoader
implements ComponentLoaderAttributes {
    private Map NAME_ATTRIBUTES = new HashMap();
    private MergeClassLoader mergeClassLoader;

    public ComponentLoader() {
        this.NAME_ATTRIBUTES.put("component", "name");
        this.NAME_ATTRIBUTES.put("interface", "name");
        this.NAME_ATTRIBUTES.put("binding", "from");
        this.NAME_ATTRIBUTES.put("attribute", "name");
        this.NAME_ATTRIBUTES.put("coordinates", "name");
        this.mergeClassLoader = new MergeClassLoader(ClassLoaderHelper.getClassLoader(this));
    }

    public String getNameAttributes() {
        StringBuffer b = new StringBuffer();
        for (Map.Entry e : this.NAME_ATTRIBUTES.entrySet()) {
            b.append((String)e.getKey());
            b.append(' ');
            b.append((String)e.getValue());
            b.append(' ');
        }
        return b.toString();
    }

    public void setNameAttributes(String nameAttributes) {
        this.NAME_ATTRIBUTES.clear();
        String key = null;
        int p = nameAttributes.indexOf(32);
        while (p != -1) {
            String s = nameAttributes.substring(0, p);
            if (key == null) {
                key = s;
            } else {
                this.NAME_ATTRIBUTES.put(key, s);
                key = null;
            }
            nameAttributes = nameAttributes.substring(p + 1);
            p = nameAttributes.indexOf(32);
        }
    }

    public Definition load(String name, Map context) throws ADLException {
        return this.load(new ArrayList(), name, context);
    }

    public Definition load(List loaded, String name, Map context) throws ADLException {
        if (loaded.contains(name)) {
            throw new ADLException("Cycle in definition references: " + loaded, null);
        }
        ArrayList<String> l = new ArrayList<String>(loaded);
        l.add(name);
        Definition d = this.clientLoader.load(name, context);
        if (d instanceof ComponentDefinition) {
            ComponentDefinition container = (ComponentDefinition)d;
            this.normalizeComponentContainer(container);
            this.resolveComponentContainer(l, container, container, context);
            if (container.getExtends() != null) {
                List defs = this.parseDefinitions(container.getExtends());
                try {
                    d = (Definition)((Object)this.merge((Node)((Object)d), (Node)((Object)this.resolveDefinitions(l, defs, context))));
                }
                catch (ADLException e) {
                    throw new ADLException("Cannot load super definition(s)", (Node)((Object)container), e);
                }
                container = (ComponentDefinition)d;
                container.setExtends(null);
            }
        }
        return d;
    }

    public void normalizeComponentContainer(ComponentContainer container) throws ADLException {
        HashSet<String> names = new HashSet<String>();
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            String name = comp.getName();
            if (name == null) {
                throw new ADLException("Component name missing", (Node)((Object)comp));
            }
            if (names.contains(name)) {
                throw new ADLException("Duplicated component name '" + name + "'", (Node)((Object)comp));
            }
            names.add(name);
            this.normalizeComponentContainer(comp);
        }
    }

    public void resolveComponentContainer(List loaded, ComponentContainer topLevelDefinition, ComponentContainer container, Map context) throws ADLException {
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Definition d;
            HashMap<Component, Component> replacements;
            Component comp = comps[i];
            this.resolveComponentContainer(loaded, topLevelDefinition, comp, context);
            String definition = comp.getDefinition();
            comp.setDefinition(null);
            ((Node)((Object)comp)).astSetDecoration("definition", definition);
            if (definition == null) continue;
            List defs = this.parseDefinitions(definition);
            if (defs.size() == 1 && this.isShared((String)defs.get(0))) {
                Component c;
                if (definition.startsWith("./")) {
                    definition = definition.substring(2);
                }
                if ((c = this.getPathComponent(topLevelDefinition, definition)) == null) {
                    throw new ADLException("No such component", (Node)((Object)comp));
                }
                if (!c.getName().equals(comps[i].getName())) {
                    throw new ADLException("Shared components with distinct names not yet supported", (Node)((Object)comp));
                }
                replacements = new HashMap();
                replacements.put(comp, c);
                this.replaceComponents(topLevelDefinition, replacements);
                continue;
            }
            try {
                d = this.resolveDefinitions(loaded, defs, context);
            }
            catch (ADLException e) {
                throw new ADLException("Cannot load referenced definition(s)", (Node)((Object)comp), e);
            }
            replacements = new HashMap<Component, Component>();
            this.merge((Node)((Object)comp), (Node)((Object)d), replacements);
            this.replaceComponents(topLevelDefinition, replacements);
        }
    }

    public List parseDefinitions(String nameList) {
        ArrayList<String> l = new ArrayList<String>();
        int p = nameList.indexOf(44);
        while (p != -1) {
            l.add(nameList.substring(0, p));
            nameList = nameList.substring(p + 1);
            p = nameList.indexOf(44);
        }
        l.add(nameList);
        return l;
    }

    public boolean isShared(String definition) {
        return definition.indexOf(47) != -1;
    }

    public Definition resolveDefinitions(List loaded, List nameList, Map context) throws ADLException {
        Definition d = this.load(loaded, (String)nameList.get(0), context);
        for (int i = 1; i < nameList.size(); ++i) {
            Definition e = this.load(loaded, (String)nameList.get(i), context);
            d = (Definition)((Object)this.merge((Node)((Object)e), (Node)((Object)d)));
        }
        return d;
    }

    public Component getComponent(ComponentContainer container, String name) {
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (!comp.getName().equals(name)) continue;
            return comp;
        }
        return null;
    }

    public Component getPathComponent(ComponentContainer container, String name) {
        int p = name.indexOf(47);
        if (p == -1) {
            return this.getComponent(container, name);
        }
        Component parent = this.getComponent(container, name.substring(0, p));
        return this.getPathComponent(parent, name.substring(p + 1));
    }

    public ComponentContainer replaceComponents(ComponentContainer container, Map replacements) {
        int i;
        if (replacements.get(container) != null) {
            return (ComponentContainer)replacements.get(container);
        }
        Component[] comps = container.getComponents();
        for (i = 0; i < comps.length; ++i) {
            container.removeComponent(comps[i]);
        }
        for (i = 0; i < comps.length; ++i) {
            container.addComponent((Component)this.replaceComponents(comps[i], replacements));
        }
        return container;
    }

    public Node merge(Node elem, Node superElem) throws ADLException {
        return this.merge(elem, superElem, null);
    }

    public Node merge(Node elem, Node superElem, Map replacements) throws ADLException {
        HashMap infos = new HashMap();
        this.computeMergeInfos(elem, superElem, infos);
        this.createMergedNodes(infos);
        Node n = this.initMergedNodes((MergeInfo)infos.get(elem), infos);
        if (replacements != null) {
            for (Map.Entry e : infos.entrySet()) {
                replacements.put(e.getKey(), ((MergeInfo)e.getValue()).result);
            }
        }
        return n;
    }

    private void computeMergeInfos(Node elem, Node superElem, Map infos) throws ADLException {
        MergeInfo info = (MergeInfo)infos.get(elem);
        if (info == null) {
            info = new MergeInfo();
            info.nodes.add(elem);
            infos.put(elem, info);
        }
        if (info.nodes.contains(superElem)) {
            return;
        }
        info.nodes.add(superElem);
        infos.put(superElem, info);
        HashSet<String> nodeTypes = new HashSet<String>();
        nodeTypes.addAll(Arrays.asList(elem.astGetNodeTypes()));
        nodeTypes.addAll(Arrays.asList(superElem.astGetNodeTypes()));
        for (String nodeType : nodeTypes) {
            int index;
            String nameAttr;
            Node[] superNodes = superElem.astGetNodes(nodeType);
            Node[] nodes = elem.astGetNodes(nodeType);
            if (superNodes == null) {
                superNodes = new Node[]{};
            }
            if (nodes == null) {
                nodes = new Node[]{};
            }
            if ((nameAttr = (String)this.NAME_ATTRIBUTES.get(nodeType)) == null) {
                if (superNodes.length > 0 && superNodes[0] != null) {
                    if (nodes.length == 0 || nodes[0] == null) {
                        this.computeMergeInfos(superNodes[0], infos);
                        continue;
                    }
                    this.computeMergeInfos(nodes[0], superNodes[0], infos);
                    continue;
                }
                if (nodes.length <= 0 || nodes[0] == null) continue;
                this.computeMergeInfos(nodes[0], infos);
                continue;
            }
            for (int k = 0; k < superNodes.length; ++k) {
                String superName = (String)superNodes[k].astGetAttributes().get(nameAttr);
                index = -1;
                for (int l = 0; l < nodes.length; ++l) {
                    String name = (String)nodes[l].astGetAttributes().get(nameAttr);
                    if (!name.equals(superName)) continue;
                    index = l;
                    break;
                }
                if (index == -1) {
                    this.computeMergeInfos(superNodes[k], infos);
                    continue;
                }
                this.computeMergeInfos(nodes[index], superNodes[k], infos);
            }
            for (int l = 0; l < nodes.length; ++l) {
                String name = (String)nodes[l].astGetAttributes().get(nameAttr);
                index = -1;
                for (int k = 0; k < superNodes.length; ++k) {
                    String superName = (String)superNodes[k].astGetAttributes().get(nameAttr);
                    if (!superName.equals(name)) continue;
                    index = k;
                    break;
                }
                if (index != -1) continue;
                this.computeMergeInfos(nodes[l], infos);
            }
        }
    }

    private void computeMergeInfos(Node node, Map infos) throws ADLException {
        MergeInfo info = (MergeInfo)infos.get(node);
        if (info != null) {
            return;
        }
        info = new MergeInfo();
        info.nodes.add(node);
        infos.put(node, info);
        String[] types = node.astGetNodeTypes();
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            Node[] subNodes = node.astGetNodes(type);
            for (int j = 0; j < subNodes.length; ++j) {
                Node subNode = subNodes[j];
                if (subNode == null) continue;
                this.computeMergeInfos(subNode, infos);
            }
        }
    }

    private void createMergedNodes(Map infos) throws ADLException {
        for (MergeInfo info : infos.values()) {
            if (info.result != null) continue;
            Node elem = (Node)info.nodes.get(0);
            ArrayList classes = new ArrayList();
            classes.add(elem.getClass());
            boolean ok = true;
            for (int j = 1; j < info.nodes.size(); ++j) {
                Class<?> sec = info.nodes.get(j).getClass();
                if (sec.getClassLoader() != ((Class)classes.get(0)).getClassLoader()) {
                    ok = false;
                }
                classes.add(sec);
            }
            if (ok) {
                try {
                    info.result = (Node)elem.getClass().newInstance();
                    continue;
                }
                catch (Exception e) {
                    throw new ADLException("Cannot merge ASTs", elem, e);
                }
            }
            try {
                int hash = elem.getClass().hashCode();
                for (int j = 1; j < classes.size(); ++j) {
                    hash = 17 * (hash + classes.get(j).hashCode());
                }
                String code = Integer.toHexString(hash);
                String name = "org.objectweb.fractal.adl.merged.Merged" + code;
                Class merged = this.mergeClassLoader.mergeClass(name, elem.astGetType(), classes.toArray(new Class[classes.size()]));
                info.result = (Node)merged.newInstance();
            }
            catch (Exception e) {
                throw new ADLException("Cannot merge AST classes", elem, e);
            }
        }
    }

    private Node initMergedNodes(MergeInfo info, Map infos) {
        if (info.done) {
            return info.result;
        }
        info.done = true;
        Node elem = (Node)info.nodes.get(0);
        Node result = info.result;
        result.astSetSource(elem.astGetSource());
        Map resultAttrs = elem.astGetAttributes();
        for (int i = 1; i < info.nodes.size(); ++i) {
            Map superAttrs = ((Node)info.nodes.get(i)).astGetAttributes();
            for (String name : superAttrs.keySet()) {
                String superValue = (String)superAttrs.get(name);
                String value = (String)resultAttrs.get(name);
                if (superValue == null || value != null) continue;
                resultAttrs.put(name, superValue);
            }
        }
        result.astSetAttributes(resultAttrs);
        Map resultDecors = elem.astGetDecorations();
        for (int i = 1; i < info.nodes.size(); ++i) {
            Map superDecors = ((Node)info.nodes.get(i)).astGetDecorations();
            resultDecors.putAll(superDecors);
        }
        result.astSetDecorations(resultDecors);
        HashSet<String> nodeTypes = new HashSet<String>();
        nodeTypes.addAll(Arrays.asList(elem.astGetNodeTypes()));
        for (int i = 1; i < info.nodes.size(); ++i) {
            nodeTypes.addAll(Arrays.asList(((Node)info.nodes.get(i)).astGetNodeTypes()));
        }
        for (String nodeType : nodeTypes) {
            int j;
            String nameAttr = (String)this.NAME_ATTRIBUTES.get(nodeType);
            ArrayList<Node> resultNodes = new ArrayList<Node>();
            Node[] nodes = elem.astGetNodes(nodeType);
            if (nodes == null) {
                nodes = new Node[]{};
            }
            for (j = 0; j < nodes.length; ++j) {
                if (nodes[j] == null) continue;
                MergeInfo inf = (MergeInfo)infos.get(nodes[j]);
                resultNodes.add(this.initMergedNodes(inf, infos));
            }
            for (j = 1; j < info.nodes.size(); ++j) {
                Node superElem = (Node)info.nodes.get(j);
                Node[] superNodes = superElem.astGetNodes(nodeType);
                if (superNodes == null) continue;
                if (nameAttr == null) {
                    if (superNodes.length <= 0 || superNodes[0] == null) continue;
                    if (nodes.length == 0 || nodes[0] == null) {
                        MergeInfo inf = (MergeInfo)infos.get(superNodes[0]);
                        resultNodes.add(this.initMergedNodes(inf, infos));
                        continue;
                    }
                    MergeInfo inf = (MergeInfo)infos.get(nodes[0]);
                    resultNodes.set(0, this.initMergedNodes(inf, infos));
                    continue;
                }
                for (int k = 0; k < superNodes.length; ++k) {
                    MergeInfo inf;
                    String superName = (String)superNodes[k].astGetAttributes().get(nameAttr);
                    int index = -1;
                    for (int l = 0; l < nodes.length; ++l) {
                        String name = (String)nodes[l].astGetAttributes().get(nameAttr);
                        if (!name.equals(superName)) continue;
                        index = l;
                        break;
                    }
                    if (index == -1) {
                        inf = (MergeInfo)infos.get(superNodes[k]);
                        resultNodes.add(this.initMergedNodes(inf, infos));
                        continue;
                    }
                    inf = (MergeInfo)infos.get(nodes[index]);
                    resultNodes.set(index, this.initMergedNodes(inf, infos));
                }
            }
            for (j = 0; j < resultNodes.size(); ++j) {
                result.astAddNode((Node)resultNodes.get(j));
            }
        }
        return info.result;
    }

    private static class MergeClassLoader
    extends NodeClassLoader {
        public MergeClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class mergeClass(String name, String astNodeName, Class[] classes) throws ClassNotFoundException {
            try {
                return this.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                HashSet<String> itfs = new HashSet<String>();
                for (int i = 0; i < classes.length; ++i) {
                    Class<?>[] citfs = classes[i].getInterfaces();
                    for (int j = 0; j < citfs.length; ++j) {
                        itfs.add(Type.getInternalName(citfs[j]));
                    }
                }
                ClassWriter cw = this.generateClass(name, astNodeName, Type.getInternalName(AbstractNode.class), itfs.toArray(new String[itfs.size()]));
                return this.defineClass(name, cw.toByteArray());
            }
        }
    }

    private static class MergeInfo {
        List nodes = new ArrayList();
        Node result;
        boolean done;

        private MergeInfo() {
        }
    }
}

