/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.Parser;
import org.objectweb.fractal.adl.ParserException;
import org.objectweb.fractal.adl.util.ClassLoaderHelper;
import org.objectweb.fractal.adl.xml.DTDHandler;
import org.objectweb.fractal.adl.xml.XMLNode;
import org.objectweb.fractal.adl.xml.XMLNodeClassLoader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler
implements Parser {
    SAXParserFactory spf;
    Map loaders = new HashMap();
    String file;
    XMLNodeClassLoader loader;
    List stack = new ArrayList();
    XMLNode result;
    Locator locator;
    int line;

    public XMLParser() {
        this(true);
    }

    public XMLParser(boolean validate) {
        this.spf = SAXParserFactory.newInstance();
        this.spf.setValidating(validate);
    }

    public Node parse(InputStream is, String name) throws ParserException {
        this.file = name;
        try {
            SAXParser sp = this.spf.newSAXParser();
            sp.parse(new InputSource(is), (DefaultHandler)this);
            return this.result;
        }
        catch (IOException e) {
            throw new ParserException("Parser error (" + this.file + ":" + this.line + ")", e);
        }
        catch (ParserConfigurationException e) {
            throw new ParserException("Parser error (" + this.file + ":" + this.line + ")", e);
        }
        catch (SAXException e) {
            throw new ParserException("Parser error (" + this.file + ":" + this.line + ")", e);
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        ClassLoader thisClassLoader = ClassLoaderHelper.getClassLoader(this);
        this.loader = (XMLNodeClassLoader)this.loaders.get(systemId);
        if (this.loader == null) {
            this.loader = new XMLNodeClassLoader(thisClassLoader);
            this.loaders.put(systemId, this.loader);
            try {
                InputStream is;
                if (systemId.startsWith("classpath://")) {
                    is = thisClassLoader.getResourceAsStream(systemId.substring("classpath://".length()));
                } else if (systemId.startsWith("file:")) {
                    is = new URL(systemId).openStream();
                } else {
                    throw new SAXNotRecognizedException("Unrecognized system identifier: " + systemId);
                }
                new DTDHandler().checkDTD(is, this.loader);
            }
            catch (MalformedURLException e) {
                throw new SAXException("Cannot find the DTD", e);
            }
            catch (IOException e) {
                throw new SAXException("Cannot read the DTD", e);
            }
            catch (ClassNotFoundException e) {
                throw new SAXException("Cannot check the DTD", e);
            }
        }
        if (systemId.startsWith("classpath://")) {
            return new InputSource(thisClassLoader.getResourceAsStream(systemId.substring("classpath://".length())));
        }
        return null;
    }

    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        XMLNode o;
        String xmlNodeClassName = this.loader.getASTClassName(qualifiedName);
        try {
            o = (XMLNode)this.loader.loadClass(xmlNodeClassName).newInstance();
        }
        catch (Exception e) {
            throw new SAXException("Internal error", e);
        }
        o.astSetSource(this.file + ":" + this.locator.getLineNumber());
        o.xmlSetAttributes(attributes);
        if (this.stack.size() == 0) {
            this.result = o;
        } else {
            Object p = this.stack.get(this.stack.size() - 1);
            ((XMLNode)p).xmlAddNode(qualifiedName, o);
        }
        this.stack.add(o);
    }

    public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
        this.stack.remove(this.stack.size() - 1);
    }

    public void error(SAXParseException e) throws SAXException {
        this.line = this.locator.getLineNumber();
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.line = this.locator.getLineNumber();
        throw e;
    }
}

