/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class J2MEConverter
extends MatchingTask {
    private File src;
    private File dst;
    private File cldcJar;
    private Set cldcAPI;
    private int errors;
    private static final String[] METHODS = new String[]{"java/util/List,size()I", "java/util/List,get(I)Ljava/lang/Object;", "java/util/List,contains(Ljava/lang/Object;)Z", "java/util/List,set(ILjava/lang/Object;)Ljava/lang/Object;", "java/util/List,add(Ljava/lang/Object;)Z", "java/util/List,add(ILjava/lang/Object;)V", "java/util/List,remove(Ljava/lang/Object;)Z", "java/util/List,remove(I)Ljava/lang/Object;", "java/util/List,toArray()[Ljava/lang/Object;", "java/util/List,toArray([Ljava/lang/Object;)[Ljava/lang/Object;", "java/util/Set,size()I", "java/util/Set,contains(Ljava/lang/Object;)Z", "java/util/Set,add(Ljava/lang/Object;)Z", "java/util/Set,toArray()[Ljava/lang/Object;", "java/util/Set,toArray([Ljava/lang/Object;)[Ljava/lang/Object;", "java/util/Map,size()I", "java/util/Map,get(Ljava/lang/Object;)Ljava/lang/Object;", "java/util/Map,put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "java/util/Map,remove(Ljava/lang/Object;)Ljava/lang/Object;", "java/util/Map,keySet()Ljava/util/Set;", "java/util/ArrayList,<init>()V", "java/util/HashSet,<init>()V", "java/util/HashMap,<init>()V"};
    private static final Map INDEXES = new HashMap();

    public void setSrcdir(File src) {
        this.src = src;
    }

    public void setDestdir(File dst) {
        this.dst = dst;
    }

    public void setCldcjar(File cldcJar) {
        this.cldcJar = cldcJar;
    }

    public void execute() {
        if (this.src == null) {
            throw new BuildException("srcdir must be specified");
        }
        if (this.dst == null) {
            throw new BuildException("destdir must be specified");
        }
        try {
            if (this.cldcJar != null) {
                this.cldcAPI = new HashSet();
                ZipFile zf = new ZipFile(this.cldcJar);
                Enumeration<? extends ZipEntry> e = zf.entries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = e.nextElement();
                    if (!ze.getName().endsWith(".class")) continue;
                    new ClassReader(zf.getInputStream(ze)).accept(new ClassAnalyzer(), true);
                }
            }
        }
        catch (Exception e) {
            this.log(e.getMessage());
        }
        int total = 0;
        String[] files = this.getDirectoryScanner(this.src).getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            ClassReader cr;
            File srcFile = new File(this.src, files[i]);
            File dstFile = new File(this.dst, files[i]);
            if (dstFile.exists() && dstFile.lastModified() > srcFile.lastModified()) continue;
            try {
                FileInputStream is = new FileInputStream(srcFile);
                cr = new ClassReader(is);
            }
            catch (Exception e) {
                this.log(e.getMessage());
                continue;
            }
            ClassWriter cw = new ClassWriter(false);
            ClassConverter converter = new ClassConverter(cw);
            cr.accept(converter, true);
            try {
                dstFile.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(dstFile);
                ((OutputStream)os).write(cw.toByteArray());
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                this.log(e.getMessage());
                continue;
            }
            ++total;
        }
        if (this.errors > 0) {
            throw new BuildException();
        }
        if (total > 0) {
            if (total == 1) {
                this.log("1 class transformed into " + this.dst);
            } else {
                this.log(total + " classes transformed into " + this.dst);
            }
        }
    }

    static String convertDescriptor(String desc) {
        boolean done;
        if (desc.equals("java/util/ArrayList")) {
            return "java/util/Vector";
        }
        if (desc.equals("java/util/HashSet")) {
            return "java/util/Hashtable";
        }
        if (desc.equals("java/util/HashMap")) {
            return "java/util/Hashtable";
        }
        String newDesc = desc;
        do {
            done = true;
            int i = newDesc.indexOf("java/util/List");
            if (i != -1) {
                newDesc = newDesc.substring(0, i) + "java/util/Vector" + newDesc.substring(i + 14);
                done = false;
            }
            if ((i = newDesc.indexOf("java/util/Set")) != -1) {
                newDesc = newDesc.substring(0, i) + "java/util/Hashtable" + newDesc.substring(i + 13);
                done = false;
            }
            if ((i = newDesc.indexOf("java/util/Map")) == -1) continue;
            newDesc = newDesc.substring(0, i) + "java/util/Hashtable" + newDesc.substring(i + 13);
            done = false;
        } while (!done);
        return newDesc;
    }

    static {
        for (int i = 0; i < METHODS.length; ++i) {
            INDEXES.put(METHODS[i], new Integer(i));
        }
    }

    class CodeConverter
    extends MethodAdapter
    implements Opcodes {
        ClassConverter c;
        String lastMethodCallInsn;
        boolean mustNotUseResult;

        public CodeConverter(ClassConverter c, MethodVisitor mv) {
            super(mv);
            this.c = c;
        }

        private void check(int opcode) {
            if (this.mustNotUseResult && opcode != 87) {
                J2MEConverter.this.log(this.c.name + ": must not use result of " + this.lastMethodCallInsn);
                ++J2MEConverter.this.errors;
            }
            this.mustNotUseResult = false;
        }

        public void visitInsn(int opcode) {
            this.check(opcode);
            this.mv.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.check(opcode);
            this.mv.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.check(opcode);
            this.mv.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String desc) {
            this.check(opcode);
            this.mv.visitTypeInsn(opcode, J2MEConverter.convertDescriptor(desc));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.check(opcode);
            if (J2MEConverter.this.cldcAPI != null && owner.startsWith("java")) {
                String key = owner + "," + name;
                if (!J2MEConverter.this.cldcAPI.contains(key)) {
                    J2MEConverter.this.log(this.c.name + ": must not use " + key + "(not in CLDC API)");
                    ++J2MEConverter.this.errors;
                }
            }
            this.mv.visitFieldInsn(opcode, owner, name, J2MEConverter.convertDescriptor(desc));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.check(opcode);
            String key = owner + "," + name + desc;
            if (J2MEConverter.this.cldcAPI != null && owner.startsWith("java") && !J2MEConverter.this.cldcAPI.contains(key) && INDEXES.get(key) == null) {
                J2MEConverter.this.log(this.c.name + ": must not use " + key + " (not in CLDC API)");
                ++J2MEConverter.this.errors;
            }
            String newDesc = J2MEConverter.convertDescriptor(desc);
            if (owner.startsWith("java/util") && !owner.equals("java/util/Vector") && !owner.equals("java/util/Hashtable") && !owner.equals("java/util/Enumeration")) {
                Integer id = (Integer)INDEXES.get(key);
                if (id == null) {
                    J2MEConverter.this.log(this.c.name + ": unauthorized method " + key);
                    ++J2MEConverter.this.errors;
                }
                this.lastMethodCallInsn = key;
                switch (id) {
                    case 0: {
                        this.mv.visitMethodInsn(182, "java/util/Vector", name, desc);
                        break;
                    }
                    case 1: {
                        this.mv.visitMethodInsn(182, "java/util/Vector", name, desc);
                        break;
                    }
                    case 2: {
                        this.mv.visitMethodInsn(182, "java/util/Vector", name, desc);
                        break;
                    }
                    case 3: {
                        this.mustNotUseResult = true;
                        this.mv.visitInsn(95);
                        this.mv.visitMethodInsn(182, "java/util/Vector", "setElementAt", "(Ljava/lang/Object;I)V");
                        this.mv.visitInsn(1);
                        break;
                    }
                    case 4: {
                        this.mustNotUseResult = true;
                        this.mv.visitMethodInsn(182, "java/util/Vector", "addElement", "(Ljava/lang/Object;)V");
                        this.mv.visitInsn(3);
                        break;
                    }
                    case 5: {
                        this.mv.visitInsn(95);
                        this.mv.visitMethodInsn(182, "java/util/Vector", "insertElementAt", "(Ljava/lang/Object;I)V");
                        break;
                    }
                    case 6: {
                        this.mv.visitMethodInsn(182, "java/util/Vector", "removeElement", desc);
                        break;
                    }
                    case 7: {
                        this.mustNotUseResult = true;
                        this.mv.visitMethodInsn(182, "java/util/Vector", "removeElementAt", "(I)V");
                        this.mv.visitInsn(1);
                        break;
                    }
                    case 8: {
                        this.mv.visitInsn(89);
                        this.mv.visitMethodInsn(182, "java/util/Vector", "size", "()I");
                        this.mv.visitTypeInsn(189, "java/lang/Object");
                        this.c.generateVectorToArrayMethod();
                        this.mv.visitMethodInsn(184, this.c.name, name, "(Ljava/util/Vector;[Ljava/lang/Object;)[Ljava/lang/Object;");
                        break;
                    }
                    case 9: {
                        this.c.generateVectorToArrayMethod();
                        this.mv.visitMethodInsn(184, this.c.name, name, "(Ljava/util/Vector;[Ljava/lang/Object;)[Ljava/lang/Object;");
                        break;
                    }
                    case 10: {
                        this.mv.visitMethodInsn(182, "java/util/Hashtable", name, desc);
                        break;
                    }
                    case 11: {
                        this.mv.visitMethodInsn(182, "java/util/Hashtable", "containsKey", desc);
                        break;
                    }
                    case 12: {
                        this.mustNotUseResult = true;
                        this.mv.visitInsn(89);
                        this.mv.visitMethodInsn(182, "java/util/Hashtable", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                        this.mv.visitInsn(87);
                        this.mv.visitInsn(3);
                        break;
                    }
                    case 13: {
                        this.mv.visitInsn(89);
                        this.mv.visitMethodInsn(182, "java/util/Hashtable", "size", "()I");
                        this.mv.visitTypeInsn(189, "java/lang/Object");
                        this.c.generateHashtableToArrayMethod();
                        this.mv.visitMethodInsn(184, this.c.name, name, "(Ljava/util/Hashtable;[Ljava/lang/Object;)[Ljava/lang/Object;");
                        break;
                    }
                    case 14: {
                        this.c.generateHashtableToArrayMethod();
                        this.mv.visitMethodInsn(184, this.c.name, name, "(Ljava/util/Hashtable;[Ljava/lang/Object;)[Ljava/lang/Object;");
                        break;
                    }
                    case 15: {
                        this.mv.visitMethodInsn(182, "java/util/Hashtable", name, desc);
                        break;
                    }
                    case 16: {
                        this.mv.visitMethodInsn(182, "java/util/Hashtable", name, desc);
                        break;
                    }
                    case 17: {
                        this.mv.visitMethodInsn(182, "java/util/Hashtable", name, desc);
                        break;
                    }
                    case 18: {
                        this.mv.visitMethodInsn(182, "java/util/Hashtable", name, desc);
                        break;
                    }
                    case 19: {
                        break;
                    }
                    case 20: {
                        this.mv.visitMethodInsn(opcode, "java/util/Vector", name, desc);
                        break;
                    }
                    case 21: {
                        this.mv.visitMethodInsn(opcode, "java/util/Hashtable", name, desc);
                        break;
                    }
                    case 22: {
                        this.mv.visitMethodInsn(opcode, "java/util/Hashtable", name, desc);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal error");
                    }
                }
            } else {
                this.mv.visitMethodInsn(opcode, owner, name, newDesc);
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.check(opcode);
            this.mv.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object cst) {
            this.check(18);
            this.mv.visitLdcInsn(cst);
        }

        public void visitIincInsn(int var, int increment) {
            this.check(132);
            this.mv.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            this.check(170);
            this.mv.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.check(171);
            this.mv.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.check(197);
            this.mv.visitMultiANewArrayInsn(desc, dims);
        }
    }

    class ClassConverter
    extends ClassAdapter
    implements Opcodes {
        private String name;
        private boolean hasVectorToArray;
        private boolean hasHashtableToArray;

        public ClassConverter(ClassVisitor cv) {
            super(cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            ArrayList<String> itfList = new ArrayList<String>(Arrays.asList(interfaces));
            itfList.remove("java/io/Serializable");
            String[] itfs = itfList.toArray(new String[itfList.size()]);
            this.cv.visit(version, access, name, signature, superName, itfs);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return this.cv.visitField(access, name, J2MEConverter.convertDescriptor(desc), signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("writeObject") && desc.equals("(Ljava/io/ObjectOutputStream;)V")) {
                return null;
            }
            if (name.equals("readObject") && desc.equals("(Ljava/io/ObjectInputStream;)V")) {
                return null;
            }
            if (name.equals("printStackTrace") && !desc.equals("()V")) {
                return null;
            }
            if (name.equals("getInputStream")) {
                MethodVisitor c = this.cv.visitMethod(access, name, desc, signature, exceptions);
                c.visitCode();
                c.visitTypeInsn(187, "java/io/IOException");
                c.visitInsn(89);
                c.visitMethodInsn(183, "java/io/IOException", "<init>", "()V");
                c.visitInsn(191);
                c.visitMaxs(2, 2);
                c.visitEnd();
                return null;
            }
            if (name.equals("_forName")) {
                MethodVisitor c = this.cv.visitMethod(access, name, desc, signature, exceptions);
                c.visitCode();
                c.visitVarInsn(25, 1);
                c.visitMethodInsn(184, "java/lang/Class", "forName", desc);
                c.visitInsn(176);
                c.visitMaxs(2, 2);
                c.visitEnd();
                return null;
            }
            String newDesc = J2MEConverter.convertDescriptor(desc);
            return new CodeConverter(this, this.cv.visitMethod(access, name, newDesc, signature, exceptions));
        }

        public void generateVectorToArrayMethod() {
            if (this.hasVectorToArray) {
                return;
            }
            this.hasVectorToArray = true;
            MethodVisitor c = this.cv.visitMethod(8, "toArray", "(Ljava/util/Vector;[Ljava/lang/Object;)[Ljava/lang/Object;", null, null);
            c.visitCode();
            c.visitInsn(3);
            c.visitVarInsn(54, 2);
            Label l0 = new Label();
            c.visitJumpInsn(167, l0);
            Label l1 = new Label();
            c.visitLabel(l1);
            c.visitVarInsn(25, 1);
            c.visitVarInsn(21, 2);
            c.visitVarInsn(25, 0);
            c.visitVarInsn(21, 2);
            c.visitMethodInsn(182, "java/util/Vector", "elementAt", "(I)Ljava/lang/Object;");
            c.visitInsn(83);
            c.visitIincInsn(2, 1);
            c.visitLabel(l0);
            c.visitVarInsn(21, 2);
            c.visitVarInsn(25, 1);
            c.visitInsn(190);
            c.visitJumpInsn(161, l1);
            c.visitVarInsn(25, 1);
            c.visitInsn(176);
            c.visitMaxs(4, 3);
            c.visitEnd();
        }

        public void generateHashtableToArrayMethod() {
            if (this.hasHashtableToArray) {
                return;
            }
            this.hasHashtableToArray = true;
            MethodVisitor c = this.cv.visitMethod(8, "toArray", "(Ljava/util/Hashtable;[Ljava/lang/Object;)[Ljava/lang/Object;", null, null);
            c.visitCode();
            c.visitInsn(3);
            c.visitVarInsn(54, 2);
            c.visitVarInsn(25, 0);
            c.visitMethodInsn(182, "java/util/Hashtable", "keys", "()Ljava/util/Enumeration;");
            c.visitVarInsn(58, 3);
            Label l0 = new Label();
            c.visitJumpInsn(167, l0);
            Label l1 = new Label();
            c.visitLabel(l1);
            c.visitVarInsn(25, 1);
            c.visitVarInsn(21, 2);
            c.visitIincInsn(2, 1);
            c.visitVarInsn(25, 3);
            c.visitMethodInsn(185, "java/util/Enumeration", "nextElement", "()Ljava/lang/Object;");
            c.visitInsn(83);
            c.visitLabel(l0);
            c.visitVarInsn(25, 3);
            c.visitMethodInsn(185, "java/util/Enumeration", "hasMoreElements", "()Z");
            c.visitJumpInsn(154, l1);
            c.visitVarInsn(25, 1);
            c.visitInsn(176);
            c.visitMaxs(3, 4);
            c.visitEnd();
        }
    }

    class ClassAnalyzer
    implements ClassVisitor,
    Opcodes {
        private String name;

        ClassAnalyzer() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldVisitor fv = null;
            if ((access & 5) != 0) {
                J2MEConverter.this.cldcAPI.add(this.name + "," + name);
            }
            return fv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 5) != 0) {
                J2MEConverter.this.cldcAPI.add(this.name + "," + name + desc);
            }
            MethodVisitor mv = null;
            return mv;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitEnd() {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }
    }
}

