/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.asm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.fractal.julia.asm.AbstractClassGenerator;
import org.objectweb.fractal.julia.asm.ClassGenerationException;
import org.objectweb.fractal.julia.loader.Initializable;
import org.objectweb.fractal.julia.loader.Tree;

public class InterfaceClassGenerator
extends AbstractClassGenerator
implements Initializable {
    private String implFieldDesc;
    static /* synthetic */ Class class$java$lang$Object;

    public void initialize(Tree args) throws Exception {
        this.superClass = args.getSubTree(0).toString().replace('.', '/');
    }

    protected void parseArgs(Tree args) {
        this.interfaces = new ArrayList<Tree>(Arrays.asList(args.getSubTree(1).getSubTrees()));
        for (int i = 0; i < this.interfaces.size(); ++i) {
            this.interfaces.set(i, this.interfaces.get(i).toString().replace('.', '/'));
        }
    }

    protected String getSource() {
        String s = this.interfaces.get(0).toString();
        if (s.lastIndexOf(47) != -1) {
            s = s.substring(s.lastIndexOf(47) + 1);
        }
        return "INTERFACE[" + s + "]";
    }

    protected void generateConstructor() throws ClassGenerationException {
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.superClass, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = this.cw.visitMethod(1, "<init>", "(Lorg/objectweb/fractal/api/Component;Ljava/lang/String;Lorg/objectweb/fractal/api/Type;ZLjava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(21, 4);
        mv.visitVarInsn(25, 5);
        mv.visitMethodInsn(183, this.superClass, "<init>", "(Lorg/objectweb/fractal/api/Component;Ljava/lang/String;Lorg/objectweb/fractal/api/Type;ZLjava/lang/Object;)V");
        mv.visitInsn(177);
        mv.visitMaxs(6, 6);
        mv.visitEnd();
    }

    protected void generateDefaultMethods() throws ClassGenerationException {
        super.generateDefaultMethods();
        this.implFieldDesc = this.interfaces.size() == 1 ? "L" + (String)this.interfaces.get(0) + ";" : "Ljava/lang/Object;";
        FieldVisitor fv = this.cw.visitField(2, "impl", this.implFieldDesc, null, null);
        if (fv != null) {
            fv.visitEnd();
        }
        String mName = "getFcItfImpl";
        String mDesc = "()Ljava/lang/Object;";
        MethodVisitor mv = this.cw.visitMethod(1, mName, mDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.name, "impl", this.implFieldDesc);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mName = "setFcItfImpl";
        mDesc = "(Ljava/lang/Object;)V";
        mv = this.cw.visitMethod(1, mName, mDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        if (this.interfaces.size() == 1) {
            mv.visitTypeInsn(192, (String)this.interfaces.get(0));
        }
        mv.visitFieldInsn(181, this.name, "impl", this.implFieldDesc);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitCode();
    }

    protected void generateMethod(Method m) {
        Class<?>[] args;
        String name = m.getName();
        String itf = Type.getInternalName(m.getDeclaringClass());
        String mDesc = Type.getMethodDescriptor(m);
        Class<?>[] exceptions = m.getExceptionTypes();
        String[] excepts = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            excepts[i] = Type.getInternalName(exceptions[i]);
        }
        if (name.equals("hashCode") && m.getParameterTypes().length == 0) {
            return;
        }
        if (name.equals("equals") && (args = m.getParameterTypes()).length == 1 && args[0].equals(class$java$lang$Object == null ? (class$java$lang$Object = InterfaceClassGenerator.class$("java.lang.Object")) : class$java$lang$Object)) {
            return;
        }
        MethodVisitor mv = this.cw.visitMethod(1, name, mDesc, null, excepts);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.name, "impl", this.implFieldDesc);
        Label l = new Label();
        mv.visitInsn(89);
        mv.visitJumpInsn(199, l);
        mv.visitTypeInsn(187, "java/lang/NullPointerException");
        mv.visitInsn(89);
        mv.visitLdcInsn("Trying to invoke a method on a client interface, or on a server interface whose complementary interface is not bound.");
        mv.visitMethodInsn(183, "java/lang/NullPointerException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitLabel(l);
        if (this.interfaces.size() > 1) {
            mv.visitTypeInsn(192, itf);
        }
        Class<?>[] params = m.getParameterTypes();
        int offset = 1;
        for (int i = 0; i < params.length; ++i) {
            mv.visitVarInsn(21 + InterfaceClassGenerator.getOpcodeOffset(params[i]), offset);
            offset += InterfaceClassGenerator.getSize(params[i]);
        }
        mv.visitMethodInsn(185, itf, name, mDesc);
        Class<?> result = m.getReturnType();
        if (result == Void.TYPE) {
            mv.visitInsn(177);
        } else {
            mv.visitInsn(172 + InterfaceClassGenerator.getOpcodeOffset(result));
        }
        int maxStack = Math.max(4, Math.max(offset, InterfaceClassGenerator.getSize(result)));
        int maxLocals = Math.max(offset, InterfaceClassGenerator.getSize(result));
        mv.visitMaxs(maxStack, maxLocals);
        mv.visitEnd();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

