/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.asm;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.fractal.julia.asm.ClassGenerationException;
import org.objectweb.fractal.julia.asm.ClassGenerator;
import org.objectweb.fractal.julia.loader.Loader;
import org.objectweb.fractal.julia.loader.Tree;

public class MixinClassGenerator
implements ClassGenerator,
Opcodes {
    String mixedClassName;
    List mixins;
    int currentMixin;
    String currentMixinClass;
    Map counters;
    static final String THIS = "_this_";
    static final String SUPER = "_super_";
    static /* synthetic */ Class class$org$objectweb$fractal$julia$loader$Generated;

    public byte[] generateClass(String name, Tree args, Loader loader, ClassLoader classLoader) throws ClassGenerationException {
        HashSet<String> providedMethods = new HashSet<String>();
        HashSet<String> providedFields = new HashSet<String>();
        HashSet<String> interfaces = new HashSet<String>();
        this.mixins = new ArrayList();
        String source = args.getSubTree(1).toString();
        for (int i = 2; i < args.getSize(); ++i) {
            String m;
            int j;
            Class mixinClass;
            try {
                mixinClass = loader.loadClass(args.getSubTree(i), (Object)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new ClassGenerationException(e, args.toString(), "Cannot load the '" + args.getSubTree(i) + "' mixin class");
            }
            Method[] meths = mixinClass.getDeclaredMethods();
            for (j = 0; j < meths.length; ++j) {
                m = meths[j].getName() + Type.getMethodDescriptor(meths[j]);
                if (m.startsWith(THIS)) {
                    if (providedMethods.contains(m)) continue;
                    throw new ClassGenerationException(null, args.toString(), "The method '" + m + "' required by the '" + mixinClass.getName() + "' mixin is missing");
                }
                if (!m.startsWith(SUPER)) continue;
                m = m.substring(SUPER.length());
                boolean overriden = false;
                for (int k = 0; k < meths.length; ++k) {
                    String n = meths[k].getName() + Type.getMethodDescriptor(meths[k]);
                    if (!n.equals(m)) continue;
                    overriden = true;
                    break;
                }
                if (!overriden) {
                    throw new ClassGenerationException(null, args.toString(), "Illegal method '" + meths[j] + "' in '" + mixinClass.getName() + "': this method is not overriden by this mixin class");
                }
                if (providedMethods.contains(THIS + m)) continue;
                throw new ClassGenerationException(null, args.toString(), "The method '" + meths[j] + "' overriden in '" + mixinClass.getName() + "' is not provided by the preceding mixins");
            }
            for (j = 0; j < meths.length; ++j) {
                m = meths[j].getName() + Type.getMethodDescriptor(meths[j]);
                if (m.startsWith(THIS) || m.startsWith(SUPER)) continue;
                providedMethods.add(THIS + m);
            }
            Field[] fields = mixinClass.getDeclaredFields();
            for (int j2 = 0; j2 < fields.length; ++j2) {
                String f = fields[j2].getName();
                if (f.startsWith(THIS)) {
                    if (providedFields.contains(f)) continue;
                    throw new ClassGenerationException(null, args.toString(), "The field '" + f + "' required by the '" + mixinClass.getName() + "' mixin is missing");
                }
                if (f.startsWith(SUPER)) {
                    throw new ClassGenerationException(null, args.toString(), "Illegal field '" + f + "' in '" + mixinClass.getName() + "': " + SUPER + " must not be used for fields");
                }
                if (providedFields.contains(THIS + f)) {
                    throw new ClassGenerationException(null, args.toString(), "The field '" + f + "' provided by the '" + mixinClass.getName() + "': mixin is already provided by a preceding mixin");
                }
                providedFields.add(THIS + f);
            }
            this.mixins.add(mixinClass);
            Class<?>[] itfs = mixinClass.getInterfaces();
            for (int j3 = 0; j3 < itfs.length; ++j3) {
                interfaces.add(Type.getInternalName(itfs[j3]));
            }
        }
        this.mixedClassName = name.replace('.', '/');
        ClassWriter cw = new ClassWriter(false);
        interfaces.add(Type.getInternalName(class$org$objectweb$fractal$julia$loader$Generated == null ? (class$org$objectweb$fractal$julia$loader$Generated = MixinClassGenerator.class$("org.objectweb.fractal.julia.loader.Generated")) : class$org$objectweb$fractal$julia$loader$Generated));
        cw.visit(196653, 1, this.mixedClassName, null, "java/lang/Object", interfaces.toArray(new String[interfaces.size()]));
        cw.visitSource("MIXIN[" + source + ']', null);
        MethodVisitor mw = cw.visitMethod(1, "<init>", "()V", null, null);
        mw.visitCode();
        mw.visitVarInsn(25, 0);
        mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mw.visitInsn(177);
        mw.visitMaxs(1, 1);
        mw.visitEnd();
        String mName = "getFcGeneratorParameters";
        String mDesc = "()Ljava/lang/String;";
        MethodVisitor mv = cw.visitMethod(1, mName, mDesc, null, null);
        mv.visitCode();
        mv.visitLdcInsn(args.toString());
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        this.counters = new HashMap();
        this.currentMixin = this.mixins.size() - 1;
        while (this.currentMixin >= 0) {
            Class c = (Class)this.mixins.get(this.currentMixin);
            this.currentMixinClass = Type.getInternalName(c);
            MixinClassAdapter mca = new MixinClassAdapter(cw);
            try {
                this.getClassReader(c).accept(mca, false);
            }
            catch (IOException e) {
                throw new ClassGenerationException(e, args.toString(), "Cannot read the mixin class " + c.getName());
            }
            this.updateCounters(c);
            --this.currentMixin;
        }
        return cw.toByteArray();
    }

    ClassReader getClassReader(Class c) throws IOException {
        try {
            return new ClassReader(c.getName());
        }
        catch (IOException e) {
            String s = Type.getInternalName(c) + ".class";
            return new ClassReader(c.getClassLoader().getResourceAsStream(s));
        }
    }

    int getCounter(String name, String desc) {
        Integer value = (Integer)this.counters.get(name + desc);
        return value == null ? -1 : value;
    }

    void updateCounters(Class c) {
        Method[] meths = c.getDeclaredMethods();
        for (int i = 0; i < meths.length; ++i) {
            Method meth = meths[i];
            String key = meth.getName();
            if (!key.startsWith(SUPER) && !key.startsWith(THIS) && (meth.getModifiers() & 0x408) != 0) continue;
            Integer value = (Integer)this.counters.get(key = key + Type.getMethodDescriptor(meth));
            int count = value == null ? 0 : value + 1;
            this.counters.put(key, new Integer(count));
        }
    }

    static boolean providesMethod(String m, Class c) {
        Method[] meths = c.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            if (!MixinClassGenerator.equals(m, meths[i])) continue;
            return true;
        }
        return false;
    }

    static boolean providesField(String f, Class c) {
        Field[] fields = c.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!f.equals(fields[i].getName())) continue;
            return true;
        }
        return false;
    }

    static boolean equals(String m, Method n) {
        String ms = m.substring(SUPER.length());
        String ns = n.getName() + Type.getMethodDescriptor(n);
        return ms.equals(ns);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MixinCodeAdapter
    extends MethodAdapter
    implements Opcodes {
        public MixinCodeAdapter(MethodVisitor cv) {
            super(cv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (name.startsWith(MixinClassGenerator.THIS)) {
                String normalName = name.substring(MixinClassGenerator.THIS.length());
                this.mv.visitFieldInsn(opcode, MixinClassGenerator.this.mixedClassName, normalName, desc);
            } else if (opcode != 178 && opcode != 179 && owner.equals(MixinClassGenerator.this.currentMixinClass)) {
                this.mv.visitFieldInsn(opcode, MixinClassGenerator.this.mixedClassName, name, desc);
            } else {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (name.startsWith(MixinClassGenerator.THIS)) {
                String normalName = name.substring(MixinClassGenerator.THIS.length());
                this.mv.visitMethodInsn(opcode, MixinClassGenerator.this.mixedClassName, normalName, desc);
            } else if (name.startsWith(MixinClassGenerator.SUPER)) {
                String normalName = name.substring(MixinClassGenerator.SUPER.length());
                String superName = normalName + "$$" + (MixinClassGenerator.this.getCounter(name, desc) + 1);
                this.mv.visitMethodInsn(183, MixinClassGenerator.this.mixedClassName, superName, desc);
            } else if (opcode != 184 && owner.equals(MixinClassGenerator.this.currentMixinClass)) {
                this.mv.visitMethodInsn(opcode, MixinClassGenerator.this.mixedClassName, name, desc);
            } else {
                this.mv.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        public void visitLineNumber(int i, Label label) {
            this.mv.visitLineNumber((MixinClassGenerator.this.currentMixin + 1) * 1000 + i, label);
        }
    }

    class MixinClassAdapter
    extends ClassAdapter
    implements Opcodes {
        public MixinClassAdapter(ClassVisitor cv) {
            super(cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldVisitor fv = null;
            if (!name.startsWith(MixinClassGenerator.THIS) && (access & 8) == 0) {
                fv = super.visitField(access, name, desc, signature, value);
            }
            return fv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv;
            if ((access & 0x508) != 0) {
                return null;
            }
            if (name.equals("<init>") || name.startsWith(MixinClassGenerator.SUPER) || name.startsWith(MixinClassGenerator.THIS)) {
                return null;
            }
            int count = MixinClassGenerator.this.getCounter(name, desc);
            if (count == -1) {
                mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            } else {
                int newAccess = access & 0xFFFFFFFA | 2;
                String newName = name + "$$" + count;
                mv = this.cv.visitMethod(newAccess, newName, desc, signature, exceptions);
            }
            return new MixinCodeAdapter(mv);
        }
    }
}

