/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.lifecycle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.control.binding.Util;
import org.objectweb.fractal.julia.control.lifecycle.ChainedIllegalLifeCycleException;
import org.objectweb.fractal.julia.control.lifecycle.LifeCycleCoordinator;

public abstract class OptimizedLifeCycleControllerMixin
implements LifeCycleCoordinator {
    public boolean fcStarted;
    public Component _this_weaveableC;

    private OptimizedLifeCycleControllerMixin() {
    }

    public String getFcState() {
        return this.fcStarted ? "STARTED" : "STOPPED";
    }

    public void startFc() throws IllegalLifeCycleException {
        Component id;
        try {
            id = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "Cannot start component");
        }
        LifeCycleCoordinator[] clccs = this.getFcLifeCycleControllers(id);
        for (int i = 0; i < clccs.length; ++i) {
            clccs[i].setFcStarted();
        }
        this._this_setFcState(true);
    }

    public void stopFc() throws IllegalLifeCycleException {
        Component id;
        try {
            id = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "Cannot stop component");
        }
        LifeCycleCoordinator[] clccs = this.getFcLifeCycleControllers(id);
        this._this_stopFc(clccs);
        this._this_setFcState(false);
    }

    public boolean setFcStarted() {
        if (!this.fcStarted) {
            this.fcStarted = true;
            return true;
        }
        return false;
    }

    public void setFcStopping(LifeCycleCoordinator coordinator) throws IllegalLifeCycleException {
        throw new Error("Internal error");
    }

    public boolean setFcStopped() {
        if (this.fcStarted) {
            this.fcStarted = false;
            return true;
        }
        return false;
    }

    public LifeCycleCoordinator[] getFcLifeCycleControllers(Component id) throws IllegalLifeCycleException {
        List clccList = this.getFcInternalLifeCycleControllers();
        Object[] sItfs = id.getFcInterfaces();
        HashSet visited = new HashSet();
        for (int i = 0; i < sItfs.length; ++i) {
            Interface sItf = (Interface)sItfs[i];
            if (((InterfaceType)sItf.getFcItfType()).isFcClientItf()) continue;
            this.getSExtLifeCycleControllers(sItf, clccList, visited);
        }
        LifeCycleCoordinator[] clccs = new LifeCycleCoordinator[clccList.size()];
        return clccList.toArray(clccs);
    }

    private void getSExtLifeCycleControllers(Interface serverItf, List clccList, Set visited) throws IllegalLifeCycleException {
        Object[] comps;
        try {
            comps = Util.getFcPotentialClientsOf(serverItf).toArray();
        }
        catch (Exception e) {
            throw new ChainedIllegalLifeCycleException(e, serverItf.getFcItfOwner(), "Cannot get the LifeCycleCoordinator interfaces");
        }
        for (int i = 0; i < comps.length; ++i) {
            Interface[] clientItfs;
            Component comp = (Component)comps[i];
            try {
                List l = Util.getFcClientItfsBoundTo(comp, serverItf);
                clientItfs = l.toArray(new Interface[l.size()]);
            }
            catch (Exception e) {
                throw new ChainedIllegalLifeCycleException(e, serverItf.getFcItfOwner(), "Cannot get the LifeCycleCoordinator interfaces");
            }
            for (int j = 0; j < clientItfs.length; ++j) {
                this.getCExtLifeCycleControllers(clientItfs[j], clccList, visited);
            }
        }
    }

    private void getCExtLifeCycleControllers(Interface clientItf, List clccList, Set visited) throws IllegalLifeCycleException {
        Component component = clientItf.getFcItfOwner();
        ContentController cc = null;
        try {
            cc = (ContentController)component.getFcInterface("content-controller");
        }
        catch (NoSuchInterfaceException e) {
            // empty catch block
        }
        if (cc != null) {
            Interface itf;
            String name = clientItf.getFcItfName();
            try {
                itf = !clientItf.isFcInternalItf() ? (Interface)cc.getFcInternalInterface(name) : (Interface)component.getFcInterface(name);
            }
            catch (NoSuchInterfaceException e) {
                throw new ChainedIllegalLifeCycleException(e, component, "Cannot find the LifeCycleCoordinator interfaces");
            }
            if (!visited.contains(itf)) {
                visited.add(itf);
                this.getSExtLifeCycleControllers(itf, clccList, visited);
            }
        } else if (!visited.contains(clientItf)) {
            LifeCycleCoordinator lcc;
            visited.add(clientItf);
            Component c = clientItf.getFcItfOwner();
            try {
                lcc = (LifeCycleCoordinator)c.getFcInterface("lifecycle-controller");
            }
            catch (Exception e) {
                try {
                    lcc = (LifeCycleCoordinator)c.getFcInterface("/lifecycle-coordinator");
                }
                catch (NoSuchInterfaceException f) {
                    throw new ChainedIllegalLifeCycleException(f, component, "Primitive client without a LifeCycleCoordinator");
                }
            }
            if (!clccList.contains(lcc)) {
                clccList.add(lcc);
            }
        }
    }

    public List getFcInternalLifeCycleControllers() throws IllegalLifeCycleException {
        Component thisComponent;
        try {
            thisComponent = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedIllegalLifeCycleException(e, this._this_weaveableC, "The OptimizedLifeCycleControllerMixin requires components to provide the Component interface");
        }
        List allSubComponents = org.objectweb.fractal.julia.control.content.Util.getAllSubComponents(thisComponent);
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < allSubComponents.size(); ++i) {
            Component c = (Component)allSubComponents.get(i);
            try {
                c.getFcInterface("content-controller");
                continue;
            }
            catch (NoSuchInterfaceException e) {
                try {
                    result.add((LifeCycleCoordinator)c.getFcInterface("lifecycle-controller"));
                    continue;
                }
                catch (Exception f) {
                    try {
                        result.add(c.getFcInterface("/lifecycle-coordinator"));
                        continue;
                    }
                    catch (NoSuchInterfaceException ignored) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    public abstract void _this_setFcState(boolean var1) throws IllegalLifeCycleException;

    public abstract void _this_stopFc(LifeCycleCoordinator[] var1) throws IllegalLifeCycleException;
}

