/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.cartography.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.objectweb.lewys.cartography.linux.Probe_LogicalDevice;
import org.objectweb.lewys.cartography.linux.Probe_PCIController;
import org.objectweb.lewys.cartography.linux.helpers.Tools;
import org.objectweb.lewys.cartography.linux.helpers.file.proc.Ide;
import org.objectweb.lewys.cartography.linux.helpers.file.proc.Scsi;
import org.objectweb.lewys.repository.cim.CIM_ManagedSystemElement;
import org.objectweb.lewys.repository.cim.CIM_MediaAccessDevice;

public class Probe_MediaAccessDevice
extends Probe_LogicalDevice {
    private static Logger logger = Logger.getLogger(Probe_PCIController.class);

    public CIM_ManagedSystemElement[] get() {
        int i;
        String[][] listIDEDevices = Ide.fetch();
        String[][] listSCSIDevices = Scsi.fetch();
        CIM_MediaAccessDevice[] temp_devices = null;
        CIM_ManagedSystemElement[] devices = null;
        int NB_MAX = 10;
        int ligne = 0;
        temp_devices = new CIM_MediaAccessDevice[NB_MAX];
        if (listIDEDevices != null) {
            for (int i2 = 0; i2 < listIDEDevices.length; ++i2) {
                if (listIDEDevices[i2][0].equals("ide-floppy")) {
                    temp_devices[ligne] = new CIM_MediaAccessDevice();
                    temp_devices[ligne].Name = "fd0";
                    temp_devices[ligne].Model = null;
                    temp_devices[ligne].Version = listIDEDevices[i2][1];
                    temp_devices[ligne].Type = "ide-floppy";
                    ++ligne;
                    continue;
                }
                if (!listIDEDevices[i2][0].equals("ide-cdrom")) continue;
                String tmp = null;
                try {
                    Process proc = Runtime.getRuntime().exec("ls /proc/ide");
                    BufferedReader resultat = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    tmp = resultat.readLine();
                    while (tmp != null) {
                        if (tmp.charAt(0) == 'h' && tmp.charAt(1) == 'd') {
                            temp_devices[ligne] = new CIM_MediaAccessDevice();
                            temp_devices[ligne].Name = tmp;
                            temp_devices[ligne].Model = Tools.openFile("/proc/ide/" + tmp, "model");
                            temp_devices[ligne].Version = listIDEDevices[i2][1];
                            temp_devices[ligne].Type = "ide-cdrom";
                            ++ligne;
                        }
                        tmp = resultat.readLine();
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        int j = 0;
        if (listSCSIDevices != null) {
            for (int i3 = 0; i3 < listSCSIDevices.length; ++i3) {
                if (!listSCSIDevices[i3][2].equals("CD-ROM")) continue;
                temp_devices[ligne] = new CIM_MediaAccessDevice();
                temp_devices[ligne].Name = "sr" + j;
                temp_devices[ligne].Model = listSCSIDevices[i3][0] + " " + listSCSIDevices[i3][1];
                temp_devices[ligne].Version = null;
                temp_devices[ligne].Type = "scsi-cdrom";
                ++ligne;
                ++j;
            }
        }
        devices = new CIM_MediaAccessDevice[ligne];
        for (i = 0; i < ligne; ++i) {
            devices[i] = temp_devices[i];
        }
        for (i = 0; i < devices.length; ++i) {
            logger.debug((Object)("PCI controller " + i + ": \n" + ((CIM_MediaAccessDevice)devices[i]).toString()));
        }
        return devices;
    }
}

