/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.common;

import java.util.TreeSet;

public class ArrayVsSetTest {
    private Deadline[] array;
    private TreeSet set;

    public ArrayVsSetTest(int size) {
        this.array = new Deadline[size];
        this.set = new TreeSet();
        this.displayMemoryUsage();
        long start = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            this.array[i] = new Deadline(i);
        }
        long end = System.currentTimeMillis();
        System.out.println("Array init time: " + (end - start) + " ms");
        this.displayMemoryUsage();
        start = System.currentTimeMillis();
        for (int i = 0; i < size; ++i) {
            this.set.add(new Deadline(i));
        }
        end = System.currentTimeMillis();
        System.out.println("TreeSet iteration time: " + (end - start) + " ms");
        this.displayMemoryUsage();
    }

    private void displayMemoryUsage() {
        System.out.println("Memory used: " + (Runtime.getRuntime().totalMemory() / 1024L / 1024L - Runtime.getRuntime().freeMemory() / 1024L / 1024L) + "MB");
    }

    public void testIterate() {
        int i;
        Deadline d3;
        int size = this.array.length;
        System.out.println("Array size: " + size);
        this.displayMemoryUsage();
        long start = System.currentTimeMillis();
        for (int i2 = 0; i2 < size; ++i2) {
            Deadline d2 = this.array[i2];
            if (d2 != null) continue;
            throw new RuntimeException("Unexpected null object in array at index " + i2);
        }
        long end = System.currentTimeMillis();
        System.out.println("Array iteration time: " + (end - start) + " ms");
        this.displayMemoryUsage();
        start = System.currentTimeMillis();
        for (Deadline d3 : this.set) {
            if (d3 != null) continue;
            throw new RuntimeException("Unexpected null object in TreeSet");
        }
        end = System.currentTimeMillis();
        System.out.println("TreeSet iteration time: " + (end - start) + " ms");
        this.displayMemoryUsage();
        start = System.currentTimeMillis();
        for (i = 0; i < size; ++i) {
            d3 = this.array[i];
            if (d3 == null) {
                throw new RuntimeException("Unexpected null object in array at index " + i);
            }
            if (d3.getDeadline() != i) {
                throw new RuntimeException("Unexpected deadline " + d3.getDeadline() + " at index " + i);
            }
            d3.setDeadline(size + i);
        }
        end = System.currentTimeMillis();
        System.out.println("Array test&set iteration time: " + (end - start) + " ms");
        this.displayMemoryUsage();
        start = System.currentTimeMillis();
        for (i = 0; i < size; ++i) {
            d3 = (Deadline)this.set.first();
            if (d3 == null) {
                throw new RuntimeException("Unexpected null object in array at index " + i);
            }
            if (d3.getDeadline() != i) {
                throw new RuntimeException("Unexpected deadline " + d3.getDeadline() + " at index " + i);
            }
            this.set.remove(d3);
            d3.setDeadline(size + i);
            this.set.add(d3);
        }
        end = System.currentTimeMillis();
        System.out.println("TreeSet test&set iteration time: " + (end - start) + " ms");
        this.displayMemoryUsage();
    }

    public static void main(String[] args) {
        try {
            ArrayVsSetTest test = new ArrayVsSetTest(Integer.parseInt(args[0]));
            test.testIterate();
        }
        catch (Exception e) {
            System.out.println("Usage is: java ArrayVsSetTest size");
            System.exit(1);
        }
    }

    private class Deadline
    implements Comparable {
        private int deadline;

        public Deadline(int deadline) {
            this.deadline = deadline;
        }

        public int compareTo(Object o) {
            if (o instanceof Deadline) {
                return this.deadline - ((Deadline)o).getDeadline();
            }
            throw new ClassCastException("Invalid type " + o);
        }

        public int getDeadline() {
            return this.deadline;
        }

        public void setDeadline(int deadline) {
            this.deadline = deadline;
        }
    }
}

