/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.filtering;

import org.objectweb.lewys.filtering.Filter;
import org.objectweb.lewys.filtering.SignalPoint;

public class LinearFilter
extends Filter {
    private SignalPoint firstPoint = null;
    private SignalPoint lastPoint = null;
    private double slope;

    public LinearFilter() {
        this(0.0);
    }

    public LinearFilter(double precisionWidth) {
        this.precisionWidth = precisionWidth;
    }

    public SignalPoint[] getKeyPoint(SignalPoint point) {
        ++this.observedPointsCount;
        if (this.firstPoint == null) {
            this.firstPoint = point;
            this.lastTime = this.firstTime = (long)this.firstPoint.getTime();
            return new SignalPoint[]{this.firstPoint};
        }
        if (this.lastPoint == null) {
            this.lastPoint = point;
            this.slope = (this.lastPoint.getValue() - this.firstPoint.getValue()) / (this.lastPoint.getTime() - this.firstPoint.getTime());
            return null;
        }
        double predictedValue = this.firstPoint.getValue() + this.slope * (point.getTime() - this.firstPoint.getTime());
        if (Math.abs(point.getValue() - predictedValue) > this.precisionWidth) {
            double firstTime = this.lastPoint.getTime();
            double firstValue = this.firstPoint.getValue() + this.slope * (this.lastPoint.getTime() - this.firstPoint.getTime());
            this.firstPoint = new SignalPoint(firstTime, firstValue);
            this.lastPoint = point;
            this.slope = (this.lastPoint.getValue() - this.firstPoint.getValue()) / (this.lastPoint.getTime() - this.firstPoint.getTime());
            this.lastTime = (long)this.firstPoint.getTime();
            return new SignalPoint[]{this.firstPoint};
        }
        this.lastPoint = point;
        return null;
    }

    public void reset(SignalPoint firstPoint, SignalPoint secondPoint) {
        this.firstPoint = firstPoint;
        if (firstPoint == secondPoint) {
            this.lastPoint = null;
        } else {
            this.lastPoint = secondPoint;
            this.slope = (secondPoint.getValue() - firstPoint.getValue()) / (secondPoint.getTime() - firstPoint.getTime());
        }
    }
}

