/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.filtering;

import org.objectweb.lewys.filtering.Filter;
import org.objectweb.lewys.filtering.LinearFilter;
import org.objectweb.lewys.filtering.SignalPoint;
import org.objectweb.lewys.filtering.SlideFilter;

public class LinearSlideFilter
extends Filter {
    private double precisionWidth = 100000.0;
    private LinearFilter linearFilter;
    private SlideFilter slideFilter;
    private int usedFilter;
    private static final int BOTH = 0;
    private static final int LINEAR = 1;
    private static final int SLIDE = 2;

    public LinearSlideFilter(double precisionWidth) {
        this.precisionWidth = precisionWidth;
        this.usedFilter = 0;
        this.linearFilter = new LinearFilter(precisionWidth);
        this.slideFilter = new SlideFilter(precisionWidth);
    }

    public SignalPoint[] getKeyPoint(SignalPoint point) {
        ++this.observedPointsCount;
        SignalPoint[] linearPoint = null;
        SignalPoint[] slidePoint = null;
        if (this.usedFilter == 0) {
            linearPoint = this.linearFilter.getKeyPoint(point);
            slidePoint = this.slideFilter.getKeyPoint(point);
        } else if (this.usedFilter == 1) {
            linearPoint = this.linearFilter.getKeyPoint(point);
            slidePoint = linearPoint;
        } else if (this.usedFilter == 2) {
            slidePoint = this.slideFilter.getKeyPoint(point);
            linearPoint = slidePoint;
        }
        if (slidePoint == null && linearPoint == null) {
            return null;
        }
        if (slidePoint != null && linearPoint == null) {
            this.usedFilter = 1;
            return null;
        }
        if (slidePoint == null && linearPoint != null) {
            this.usedFilter = 2;
            return null;
        }
        if (slidePoint != null && linearPoint != null) {
            this.usedFilter = 0;
            this.linearFilter.reset(slidePoint[0], point);
            this.slideFilter.reset(slidePoint[0], point);
            if (this.observedPointsCount == 1) {
                this.firstTime = (long)slidePoint[0].getTime();
            }
            this.lastTime = (long)slidePoint[0].getTime();
            return slidePoint;
        }
        return null;
    }
}

