/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe;

import org.objectweb.lewys.probe.Probe;

public class ProbePerformanceTest {
    private Probe probe;

    public ProbePerformanceTest(Probe probeToTest) {
        this.probe = probeToTest;
        System.out.println("*** Testing probe on one resource ***");
        int[] oneResource = new int[]{this.probe.getResourceIds()[0]};
        this.testResources(1000000, oneResource);
        System.out.println("*** Testing probe on all resources (" + this.probe.getResourceIds().length + ") ***");
        this.testResources(1000000, this.probe.getResourceIds());
    }

    public void testResources(int nbOfCalls, int[] resourceIds) {
        if (nbOfCalls <= 0) {
            return;
        }
        System.gc();
        long freeMemStart = Runtime.getRuntime().freeMemory();
        long start = System.currentTimeMillis();
        for (int i = 0; i < nbOfCalls; ++i) {
            try {
                this.probe.getValue(resourceIds);
                continue;
            }
            catch (Exception e) {
                System.err.println("Probe failed: " + e);
                e.printStackTrace();
            }
        }
        long end = System.currentTimeMillis();
        long freeMemEnd = Runtime.getRuntime().freeMemory();
        System.out.println("Total time: " + (end - start) + " ms");
        System.out.println("Total memory used: " + (freeMemStart - freeMemEnd) + " bytes");
        System.out.println("Memory used per call: " + (float)(freeMemStart - freeMemEnd) / (float)nbOfCalls + " bytes");
        System.out.println("Time per call: " + (float)(end - start) / (float)nbOfCalls + " ms");
        System.out.println("Calls per second: " + (float)nbOfCalls / (float)(end - start) * 1000.0f);
    }
}

