/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.jmx;

import java.util.ArrayList;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.jmx.JmxClient;

public class JmxProbe
extends AbstractProbe {
    private static final int NB_OF_RESSOURCES = 5;
    private long[] resourceValues;
    private String[] resourceTypes;
    private JmxClient jmxClient;

    public JmxProbe(String host, String port, Object credentials) throws NoResourceToProbeException {
        super("JMX probe");
        int i;
        int intCount;
        ArrayList resNames = new ArrayList();
        try {
            this.jmxClient = new JmxClient(host, port, credentials);
            resNames.addAll(this.jmxClient.getAttribNames("java.lang.Integer"));
            intCount = resNames.size();
            resNames.addAll(this.jmxClient.getAttribNames("java.lang.Long"));
            intCount = resNames.size() - intCount;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoResourceToProbeException(e);
        }
        this.resourceIds = new int[resNames.size()];
        this.resourceValues = new long[resNames.size()];
        this.resourceTypes = new String[resNames.size()];
        for (i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
        for (i = 0; i < intCount; ++i) {
            this.resourceTypes[i] = "int";
        }
        for (i = intCount; i < this.resourceIds.length; ++i) {
            this.resourceTypes[i] = "long";
        }
        this.resourceNames = (String[])resNames.toArray();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        long[] result = new long[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] > resourceIds.length) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            try {
                if (this.resourceTypes[i].equals("int")) {
                    result[i] = ((Integer)this.jmxClient.getAttribValue(this.resourceNames[i])).intValue();
                } else if (this.resourceTypes[i].equals("long")) {
                    result[i] = (Long)this.jmxClient.getAttribValue(this.resourceNames[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ProbeException(e);
            }
            result[i] = this.resourceValues[resourceIds[i]];
        }
        return result;
    }
}

