/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.jmx.cjdbc;

import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.probe.Probe;
import org.objectweb.lewys.probe.jmx.cjdbc.CjdbcProbe;

public class CjdbcProbeTest {
    public static void main(String[] args) {
        try {
            CjdbcProbe probe = new CjdbcProbe();
            CjdbcProbeTest.testFunctionality(probe, 5, probe.getResourceIds());
            int[] resourceIds = probe.getResourceIds();
            for (int i = 0; i < 20; ++i) {
                probe.initThreads(i + 1);
                int[] testResourceIds = new int[20];
                for (int j = 0; j < testResourceIds.length; ++j) {
                    testResourceIds[j] = 0;
                }
                CjdbcProbeTest.generateLoad(probe, 600000, testResourceIds);
            }
        }
        catch (NoResourceToProbeException e) {
            System.err.println("Unable to load probe");
            e.printStackTrace();
        }
    }

    public static void testFunctionality(Probe probe, int nbOfCalls, int[] resourceIds) {
        if (nbOfCalls <= 0) {
            return;
        }
        System.out.println("Testing probe");
        for (int i = 0; i < nbOfCalls; ++i) {
            try {
                long[] values = probe.getValue(resourceIds);
                for (int j = 0; j < values.length; ++j) {
                    System.out.println(probe.getResourceName(resourceIds[j]) + ": " + values[j]);
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                System.err.println("Probe failed: " + e);
                e.printStackTrace();
            }
        }
    }

    public static void testPerformance(Probe probe, int nbOfCalls, int[] resourceIds) {
        if (nbOfCalls <= 0) {
            return;
        }
        System.out.println("Testing probe");
        System.gc();
        long freeMemStart = Runtime.getRuntime().freeMemory();
        long start = System.currentTimeMillis();
        for (int i = 0; i < nbOfCalls; ++i) {
            try {
                probe.getValue(resourceIds);
                continue;
            }
            catch (Exception e) {
                System.err.println("Probe failed: " + e);
                e.printStackTrace();
            }
        }
        long end = System.currentTimeMillis();
        long freeMemEnd = Runtime.getRuntime().freeMemory();
        System.out.println("Total time: " + (end - start) + " ms");
        System.out.println("Total memory used: " + (freeMemStart - freeMemEnd) + " bytes");
        System.out.println("Memory used per call: " + (float)(freeMemStart - freeMemEnd) / (float)nbOfCalls + " bytes");
        System.out.println("Time per call: " + (float)(end - start) / (float)nbOfCalls + " ms");
        System.out.println("Calls per second: " + (float)nbOfCalls / (float)(end - start) * 1000.0f);
    }

    public static void generateLoad(Probe probe, int nbOfCalls, int[] resourceIds) {
        if (nbOfCalls <= 0) {
            return;
        }
        for (int i = 0; i < nbOfCalls; ++i) {
            try {
                probe.getValue(resourceIds);
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                System.err.println("Probe failed: " + e);
                e.printStackTrace();
            }
        }
    }
}

