/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.jmx.cjdbc;

import java.io.IOException;
import java.util.ArrayList;
import org.objectweb.cjdbc.common.exceptions.DataCollectorException;
import org.objectweb.cjdbc.common.monitor.AbstractDataCollector;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.probe.jmx.cjdbc.CjdbcJmxClient;
import org.objectweb.lewys.probe.jmx.cjdbc.CjdbcProbe;
import org.objectweb.lewys.probe.jmx.cjdbc.CjdbcProbeCompletion;

public class CjdbcProbeThread
extends Thread {
    private boolean killed = false;
    private CjdbcProbe father;
    private CjdbcJmxClient jmxClient;
    private int resourceId;
    private String[] virtualDBNames;
    private String[] virtualDBResourceNames;
    private int[] virtualDBResourceIds;
    private String[] controllerResourceNames;
    private int[] controllerResourceIds;

    public CjdbcProbeThread(CjdbcProbe father) throws NoResourceToProbeException {
        super("CjdbcProbeThread");
        this.father = father;
        this.virtualDBNames = father.getVirtualDBNames();
        this.virtualDBResourceNames = father.getVirtualDBResourceNames();
        this.virtualDBResourceIds = father.getVirtualDBResourceIds();
        this.controllerResourceNames = father.getControllerResourceNames();
        this.controllerResourceIds = father.getControllerResourceIds();
        this.jmxClient = father.getJmxClient();
    }

    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            ArrayList arrayList = this.father.jobs;
            synchronized (arrayList) {
                try {
                    if (this.father.jobs.size() == 0) {
                        this.father.jobs.wait();
                    }
                }
                catch (InterruptedException ie) {
                    if (this.isKilled()) {
                        return;
                    }
                    System.err.println("CjdbcProbe child thead has been interrupted.");
                }
                if (this.father.jobs.size() <= 0) {
                    continue;
                }
                this.resourceId = (Integer)this.father.jobs.remove(0);
            }
            AbstractDataCollector collector = null;
            int resourcesCount = 5 + 13 * this.virtualDBNames.length;
            try {
                if (this.resourceId < 5) {
                    collector = this.jmxClient.getDataCollectorProxy().retrieveDataCollectorInstance(this.controllerResourceIds[this.resourceId], null, null);
                } else if (this.resourceId < resourcesCount) {
                    int virtualDBResourceId = this.virtualDBResourceIds[(this.resourceId - 5) % 13];
                    String virtualDBName = this.virtualDBNames[(this.resourceId - 5) / 13];
                    collector = this.jmxClient.getDataCollectorProxy().retrieveDataCollectorInstance(virtualDBResourceId, null, virtualDBName);
                }
                this.father.setResourceValue(this.resourceId, this.jmxClient.getDataCollectorProxy().retrieveData(collector));
                CjdbcProbeCompletion virtualDBResourceId = this.father.completion;
                synchronized (virtualDBResourceId) {
                    this.father.completion.completed();
                    continue;
                }
            }
            catch (DataCollectorException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public boolean isKilled() {
        return this.killed;
    }

    public void setKilled(boolean killed) {
        this.killed = killed;
    }
}

