/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lewys.probe.linux;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.common.exceptions.NoSuchResourceException;
import org.objectweb.lewys.common.exceptions.ProbeException;
import org.objectweb.lewys.probe.AbstractProbe;
import org.objectweb.lewys.probe.Probe;

public class CpuProbe
extends AbstractProbe
implements Probe {
    private static final int NB_OF_RESSOURCES = 4;
    private long[] cpuUser;
    private long[] cpuNice;
    private long[] cpuSys;
    private long[] cpuIdle;
    private int nbOfCpus = 0;
    private RandomAccessFile procFile;
    private byte[] buffer;
    private static NoResourceToProbeException invalidFileFormat = new NoResourceToProbeException("Invalid /proc/stat file format for this probe.");
    private static final int BUFFER_SIZE = 1024;

    public CpuProbe() throws NoResourceToProbeException {
        super("cpu probe");
        int i;
        try {
            this.procFile = new RandomAccessFile("/proc/stat", "r");
            this.buffer = new byte[1024];
            this.procFile.read(this.buffer);
            i = 0;
            while (this.buffer[i++] == 99) {
                if (this.buffer[i++] != 112) {
                    throw invalidFileFormat;
                }
                if (this.buffer[i++] != 117) {
                    throw invalidFileFormat;
                }
                while (this.buffer[i] != 32) {
                    ++i;
                }
                while (this.buffer[i] == 32) {
                    ++i;
                }
                for (int cpuStat = 0; cpuStat < 4; ++cpuStat) {
                    while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                        ++i;
                    }
                    if (this.buffer[i] != 32 && this.buffer[i] != 10 && this.buffer[i] != 13) {
                        throw invalidFileFormat;
                    }
                    while (this.buffer[i] == 32) {
                        ++i;
                    }
                }
                while (this.buffer[i] != 10) {
                    ++i;
                }
                ++this.nbOfCpus;
                if (++i < 1024) continue;
                break;
            }
        }
        catch (Exception e) {
            try {
                this.procFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
            throw new NoResourceToProbeException(e);
        }
        if (this.nbOfCpus == 0) {
            throw new NoResourceToProbeException();
        }
        this.cpuUser = new long[this.nbOfCpus];
        this.cpuNice = new long[this.nbOfCpus];
        this.cpuSys = new long[this.nbOfCpus];
        this.cpuIdle = new long[this.nbOfCpus];
        this.resourceNames = new String[this.nbOfCpus * 4];
        this.resourceNames[0] = "cpu user";
        this.resourceNames[1] = "cpu nice";
        this.resourceNames[2] = "cpu kernel";
        this.resourceNames[3] = "cpu idle";
        for (i = 1; i < this.nbOfCpus; ++i) {
            this.resourceNames[i * 4] = "cpu" + (i - 1) + " user";
            this.resourceNames[i * 4 + 1] = "cpu" + (i - 1) + " nice";
            this.resourceNames[i * 4 + 2] = "cpu" + (i - 1) + " kernel";
            this.resourceNames[i * 4 + 3] = "cpu" + (i - 1) + " idle";
        }
        this.resourceIds = new int[this.resourceNames.length];
        for (i = 0; i < this.resourceIds.length; ++i) {
            this.resourceIds[i] = i;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.procFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    public long[] getValue(int[] resourceIds) throws ProbeException, NoSuchResourceException {
        this.getCpuUsage();
        long[] result = new long[resourceIds.length];
        block6: for (int i = 0; i < resourceIds.length; ++i) {
            if (resourceIds[i] >= 4 * this.nbOfCpus) {
                throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
            }
            int cpu = resourceIds[i] / 4;
            switch (resourceIds[i] % 4) {
                case 0: {
                    result[i] = this.cpuUser[cpu];
                    continue block6;
                }
                case 1: {
                    result[i] = this.cpuNice[cpu];
                    continue block6;
                }
                case 2: {
                    result[i] = this.cpuSys[cpu];
                    continue block6;
                }
                case 3: {
                    result[i] = this.cpuIdle[cpu];
                    continue block6;
                }
                default: {
                    throw new NoSuchResourceException("Resource " + resourceIds[i] + " is not valid");
                }
            }
        }
        return result;
    }

    private void getCpuUsage() throws ProbeException {
        try {
            this.procFile.seek(0L);
            this.procFile.read(this.buffer);
            int i = 4;
            int currentCpu = 0;
            while (true) {
                if (this.buffer[i] != 32) {
                    ++i;
                    continue;
                }
                while (this.buffer[i] == 32) {
                    ++i;
                }
                long foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.cpuUser[currentCpu] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.cpuNice[currentCpu] = foo;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                foo = 0L;
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.cpuSys[currentCpu] = foo;
                foo = 0L;
                while (this.buffer[i] == 32) {
                    ++i;
                }
                while (this.buffer[i] >= 48 && this.buffer[i] <= 57) {
                    foo = foo * 10L + (long)this.buffer[i] - 48L;
                    ++i;
                }
                this.cpuIdle[currentCpu] = foo;
                while (this.buffer[i] != 10) {
                    ++i;
                }
                i += 4;
                if (++currentCpu >= this.nbOfCpus) break;
            }
        }
        catch (Exception e) {
            throw new ProbeException(e);
        }
    }
}

